﻿---
title: Elasticsearch node_stats metricset
description: The node_stats metricset interrogates the Cluster API endpoint of Elasticsearch to get the cluster nodes statistics. The data received is only for the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-node_stats
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch node_stats metricset
The `node_stats` metricset interrogates the [Cluster API endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-stats) of Elasticsearch to get the cluster nodes statistics. The data received is only for the local node so this Metricbeat has to be run on each Elasticsearch node.
<note>
  The indices stats are node-specific. That means for example the total number of docs reported by all nodes together is not the total number of documents in all indices as there can also be replicas.
</note>

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2025-01-28T14:39:37.450Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        },
        "node": {
            "id": "f5i3v9hMT_q__q6B9WOo5A",
            "master": true,
            "mlockall": false,
            "name": "27fb1c2fd783",
            "stats": {
                "fs": {
                    "total": {
                        "total_in_bytes": 128849018880,
                        "available_in_bytes": 122770808832
                    },
                    "io_stats": {
                        "total": {
                            "read": {
                                "kb": 33942834,
                                "operations": {
                                    "count": 728301
                                }
                            },
                            "write": {
                                "kb": 3788536676,
                                "operations": {
                                    "count": 719077269
                                }
                            },
                            "operations": {
                                "count": 719805570
                            }
                        }
                    },
                    "summary": {
                        "free": {
                            "bytes": 122770808832
                        },
                        "available": {
                            "bytes": 122770808832
                        },
                        "total": {
                            "bytes": 128849018880
                        }
                    }
                },
                "indexing_pressure": {
                    "memory": {
                        "current": {
                            "replica": {
                                "bytes": 0
                            },
                            "combined_coordinating_and_primary": {
                                "bytes": 0
                            },
                            "all": {
                                "bytes": 0
                            },
                            "primary": {
                                "bytes": 0
                            },
                            "coordinating": {
                                "bytes": 0
                            }
                        },
                        "total": {
                            "all": {
                                "bytes": 220351441747
                            },
                            "primary": {
                                "bytes": 246538295411,
                                "rejections": 0
                            },
                            "coordinating": {
                                "rejections": 0,
                                "bytes": 220351430734
                            },
                            "replica": {
                                "rejections": 0,
                                "bytes": 0
                            },
                            "combined_coordinating_and_primary": {
                                "bytes": 220351441747
                            }
                        },
                        "limit_in_bytes": 195873996
                    }
                },
                "indices": {
                    "indexing": {
                        "index_time": {
                            "ms": 5609149
                        },
                        "index_total": {
                            "count": 46090439
                        },
                        "throttle_time": {
                            "ms": 0
                        }
                    },
                    "shard_stats": {
                        "total_count": 140
                    },
                    "merges": {
                        "total_time": {
                            "ms": 4864222
                        },
                        "total": {
                            "count": 241354
                        }
                    },
                    "flush": {
                        "total_time": {
                            "ms": 12498263
                        },
                        "total": {
                            "count": 540712
                        }
                    },
                    "refresh": {
                        "total_time": {
                            "ms": 15830993
                        },
                        "total": {
                            "count": 3787539
                        }
                    },
                    "query_cache": {
                        "memory": {
                            "bytes": 31842281
                        }
                    },
                    "docs": {
                        "deleted": 263,
                        "count": 12575085
                    },
                    "get": {
                        "time": {
                            "ms": 562391
                        },
                        "total": {
                            "count": 7756876
                        }
                    },
                    "segments": {
                        "norms": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "terms": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "index_writer": {
                            "memory": {
                                "bytes": 1055088
                            }
                        },
                        "version_map": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "doc_values": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "fixed_bit_set": {
                            "memory": {
                                "bytes": 953472
                            }
                        },
                        "points": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "stored_fields": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "count": 1257,
                        "term_vectors": {
                            "memory": {
                                "bytes": 0
                            }
                        },
                        "memory": {
                            "bytes": 0
                        }
                    },
                    "fielddata": {
                        "evictions": {
                            "count": 24
                        },
                        "memory": {
                            "bytes": 512
                        }
                    },
                    "translog": {
                        "operations": {
                            "count": 882
                        },
                        "size": {
                            "bytes": 3027983
                        }
                    },
                    "search": {
                        "fetch_time": {
                            "ms": 756010
                        },
                        "fetch_total": {
                            "count": 19706537
                        },
                        "query_time": {
                            "ms": 7451765
                        },
                        "query_total": {
                            "count": 22765302
                        }
                    },
                    "store": {
                        "size": {
                            "bytes": 5347443305
                        },
                        "total_data_set_size": {
                            "bytes": 5347443305
                        }
                    },
                    "request_cache": {
                        "memory": {
                            "bytes": 1110448
                        }
                    },
                    "bulk": {
                        "avg_size": {
                            "bytes": 46429
                        },
                        "avg_time": {
                            "ms": 0
                        },
                        "total_size": {
                            "bytes": 215948271738
                        },
                        "total_time": {
                            "ms": 8953160
                        },
                        "operations": {
                            "total": {
                                "count": 4685819
                            }
                        }
                    }
                },
                "ingest": {
                    "total": {
                        "time_in_millis": 2285355,
                        "current": 0,
                        "failed": 0,
                        "count": 19355426
                    }
                },
                "jvm": {
                    "gc": {
                        "collectors": {
                            "young": {
                                "collection": {
                                    "ms": 1973140,
                                    "count": 61012
                                }
                            },
                            "old": {
                                "collection": {
                                    "count": 0,
                                    "ms": 0
                                }
                            }
                        }
                    },
                    "mem": {
                        "pools": {
                            "young": {
                                "used": {
                                    "bytes": 562036736
                                },
                                "max": {
                                    "bytes": 0
                                },
                                "peak": {
                                    "bytes": 1161822208
                                },
                                "peak_max": {
                                    "bytes": 0
                                }
                            },
                            "survivor": {
                                "used": {
                                    "bytes": 23068672
                                },
                                "max": {
                                    "bytes": 0
                                },
                                "peak": {
                                    "bytes": 62914560
                                },
                                "peak_max": {
                                    "bytes": 0
                                }
                            },
                            "old": {
                                "used": {
                                    "bytes": 392190120
                                },
                                "max": {
                                    "bytes": 1958739968
                                },
                                "peak": {
                                    "bytes": 409689360
                                },
                                "peak_max": {
                                    "bytes": 1958739968
                                }
                            }
                        },
                        "heap": {
                            "max": {
                                "bytes": 1958739968
                            },
                            "used": {
                                "bytes": 977295528,
                                "pct": 49
                            }
                        }
                    },
                    "threads": {
                        "count": 127
                    }
                },
                "os": {
                    "cpu": {
                        "load_avg": {
                            "1m": 0.64
                        }
                    },
                    "cgroup": {
                        "cpuacct": {
                            "usage": {
                                "ns": 209789071276757
                            }
                        },
                        "cpu": {
                            "cfs": {
                                "quota": {
                                    "us": 220689
                                }
                            },
                            "stat": {
                                "times_throttled": {
                                    "count": 36629
                                },
                                "time_throttled": {
                                    "ns": 6561820668942
                                },
                                "elapsed_periods": {
                                    "count": 25671143
                                }
                            }
                        },
                        "memory": {
                            "limit": {
                                "bytes": "4294967296"
                            },
                            "usage": {
                                "bytes": "3965923328"
                            },
                            "control_group": "/"
                        }
                    }
                },
                "process": {
                    "mem": {
                        "total_virtual": {
                            "bytes": 18230607872
                        }
                    },
                    "open_file_descriptors": 1074,
                    "cpu": {
                        "pct": 2
                    }
                },
                "thread_pool": {
                    "search": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "flush": {
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        },
                        "active": {
                            "count": 0
                        }
                    },
                    "force_merge": {
                        "rejected": {
                            "count": 0
                        },
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        }
                    },
                    "get": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "system_write": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "system_read": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "write": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "snapshot": {
                        "active": {
                            "count": 0
                        },
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        }
                    },
                    "esql_worker": {
                        "queue": {
                            "count": 0
                        },
                        "rejected": {
                            "count": 0
                        },
                        "active": {
                            "count": 0
                        }
                    }
                },
                "transport": {
                    "tx": {
                        "count": 6974845,
                        "size": {
                            "bytes": 13076882004
                        }
                    },
                    "rx": {
                        "count": 6974819,
                        "size": {
                            "bytes": 36906511403
                        }
                    }
                }
            }
        }
    },
    "event": {
        "dataset": "elasticsearch.node.stats",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "node_stats",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "name": "elasticsearch",
        "type": "elasticsearch"
    }
}
```