﻿---
title: Elasticsearch node metricset
description: The node metricset interrogates the Cluster API endpoint of Elasticsearch to get cluster nodes information. This metricset only fetches the data from...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-node
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch node metricset
The `node` metricset interrogates the [Cluster API endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-info) of Elasticsearch to get cluster nodes information. This metricset only fetches the data from the `_local` node so it must run on each Elasticsearch node.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        },
        "node": {
            "id": "f5i3v9hMT_q__q6B9WOo5A",
            "jvm": {
                "memory": {
                    "heap": {
                        "init": {
                            "bytes": 268435456
                        },
                        "max": {
                            "bytes": 268435456
                        }
                    },
                    "nonheap": {
                        "init": {
                            "bytes": 7667712
                        },
                        "max": {
                            "bytes": 0
                        }
                    }
                },
                "version": "16.0.1"
            },
            "name": "27fb1c2fd783",
            "process": {
                "mlockall": false
            },
            "version": "7.14.0"
        }
    },
    "event": {
        "dataset": "elasticsearch.node",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "node",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "name": "elasticsearch",
        "type": "elasticsearch"
    }
}
```