﻿---
title: Elasticsearch ml_job metricset
description: This is the ml_job metricset of the Elasticsearch module. This metricset requires Machine Learning to be enabled. For a description of each field in the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-ml_job
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch ml_job metricset
This is the `ml_job` metricset of the Elasticsearch module. This metricset requires [Machine Learning](https://www.elastic.co/products/x-pack/machine-learning) to be enabled.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        },
        "ml": {
            "job": {
                "data_counts": {
                    "invalid_date_count": 0,
                    "processed_record_count": 0
                },
                "forecasts_stats": {
                    "total": 0
                },
                "id": "total-requests",
                "model_size": {
                    "memory_status": "ok"
                },
                "state": "closed"
            }
        },
        "node": {
            "id": "27fb1c2fd783",
            "name": "node-1"
        }
    },
    "event": {
        "dataset": "elasticsearch.ml.job",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "ml_job",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "name": "elasticsearch",
        "type": "elasticsearch"
    }
}
```