﻿---
title: Elasticsearch index_recovery metricset
description: This is the index_recovery metricset of the module Elasticsearch. By default data about all indices are fetched. To gather data about indices that are...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-index_recovery
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch index_recovery metricset
This is the index_recovery metricset of the module Elasticsearch.
By default data about all indices are fetched. To gather data about indices that are under active recovery only, set `index_recovery.active_only: true`:
```yaml
- module: elasticsearch
  metricsets:
    - index_recovery
  hosts: ["localhost:9200"]
  index_recovery.active_only: false
```


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        },
        "index": {
            "name": "users",
            "recovery": {
                "id": 0,
                "index": {
                    "files": {
                        "percent": "0.0%",
                        "recovered": 0,
                        "reused": 0,
                        "total": 0
                    },
                    "size": {
                        "recovered_in_bytes": 0,
                        "reused_in_bytes": 0,
                        "total_in_bytes": 0
                    }
                },
                "name": "users",
                "primary": true,
                "source": {},
                "stage": "DONE",
                "start_time": {
                    "ms": 1635956540240
                },
                "stop_time": {
                    "ms": 1635956540265
                },
                "target": {
                    "host": "127.0.0.1",
                    "id": "f5i3v9hMT_q__q6B9WOo5A",
                    "name": "27fb1c2fd783",
                    "transport_address": "127.0.0.1:9300"
                },
                "translog": {
                    "percent": "100.0%",
                    "total": 0,
                    "total_on_start": 0
                },
                "type": "EMPTY_STORE"
            }
        }
    },
    "event": {
        "dataset": "elasticsearch.index.recovery",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "index_recovery",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "name": "elasticsearch",
        "type": "elasticsearch"
    }
}
```