﻿---
title: Elasticsearch enrich metricset
description: This is the enrich metricset of the Elasticsearch module. It interrogates the Enrich Stats API endpoint to fetch information about Enrich coordinator...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-enrich
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch enrich metricset
This is the `enrich` metricset of the Elasticsearch module. It interrogates the Enrich Stats API endpoint to fetch information about Enrich coordinator nodes in the Elasticsearch cluster that are participating in ingest-time enrichment.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        },
        "enrich": {
            "executed_searches": {
                "total": 1
            },
            "queue": {
                "size": 0
            },
            "remote_requests": {
                "current": 0,
                "total": 1
            }
        },
        "node": {
            "id": "f5i3v9hMT_q__q6B9WOo5A"
        }
    },
    "event": {
        "dataset": "elasticsearch.enrich",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "enrich",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "type": "elasticsearch"
    }
}
```