﻿---
title: Elasticsearch ccr metricset
description: This is the ccr metricset of the Elasticsearch module. It uses the Cross-Cluster Replication Stats API endpoint to fetch metrics about cross-cluster replication...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-ccr
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch ccr metricset
This is the `ccr` metricset of the Elasticsearch module. It uses the Cross-Cluster Replication Stats API endpoint to fetch metrics about cross-cluster replication from the Elasticsearch clusters that are participating in cross-cluster replication.
If the Elasticsearch cluster does not have cross-cluster replication enabled, this metricset will not collect metrics. A DEBUG log message about this will be emitted in the Metricbeat log.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "ccr": {
            "auto_follow": {
                "failed": {
                    "follow_indices": {
                        "count": 0
                    },
                    "remote_cluster_state_requests": {
                        "count": 0
                    }
                },
                "success": {
                    "follow_indices": {
                        "count": 0
                    }
                }
            },
            "bytes_read": 0,
            "follower": {
                "aliases_version": 1,
                "global_checkpoint": -1,
                "index": "rats",
                "max_seq_no": -1,
                "operations": {
                    "read": {
                        "count": 0
                    }
                },
                "operations_written": 0,
                "settings_version": 1,
                "shard": {
                    "number": 0
                },
                "time_since_last_read": {
                    "ms": 3095
                }
            },
            "leader": {
                "global_checkpoint": -1,
                "index": "pied_piper",
                "max_seq_no": -1
            },
            "read_exceptions": [],
            "requests": {
                "failed": {
                    "read": {
                        "count": 0
                    },
                    "write": {
                        "count": 0
                    }
                },
                "outstanding": {
                    "read": {
                        "count": 1
                    },
                    "write": {
                        "count": 0
                    }
                },
                "successful": {
                    "read": {
                        "count": 0
                    },
                    "write": {
                        "count": 0
                    }
                }
            },
            "total_time": {
                "read": {
                    "ms": 0,
                    "remote_exec": {
                        "ms": 0
                    }
                },
                "write": {
                    "ms": 0
                }
            },
            "write_buffer": {
                "operation": {
                    "count": 0
                },
                "size": {
                    "bytes": 0
                }
            }
        },
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster"
        }
    },
    "event": {
        "dataset": "elasticsearch.ccr",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "ccr",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "name": "elasticsearch",
        "type": "elasticsearch"
    }
}
```