﻿---
title: Dropwizard collector metricset
description: This is the collector metricset of the Dropwizard module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-dropwizard-collector
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Dropwizard collector metricset
This is the `collector` metricset of the Dropwizard module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-dropwizard) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "dropwizard": {
        "testnamespace": {
            "my_gauge": {},
            "my_histogram": {
                "count": 0,
                "max": 0,
                "mean": 0,
                "min": 0,
                "p50": 0,
                "p75": 0,
                "p95": 0,
                "p98": 0,
                "p99": 0,
                "p999": 0,
                "stddev": 0
            },
            "my_timer": {
                "count": 0,
                "duration_units": "seconds",
                "m15_rate": 0,
                "m1_rate": 0,
                "m5_rate": 0,
                "max": 0,
                "mean": 0,
                "mean_rate": 0,
                "min": 0,
                "p50": 0,
                "p75": 0,
                "p95": 0,
                "p98": 0,
                "p99": 0,
                "p999": 0,
                "rate_units": "calls/second",
                "stddev": 0
            }
        }
    },
    "event": {
        "dataset": "dropwizard.testnamespace",
        "duration": 115000,
        "module": "dropwizard"
    },
    "metricset": {
        "name": "collector",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "dropwizard"
    }
}
```