﻿---
title: Docker network metricset
description: The Docker network metricset collects network metrics. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-network
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker network metricset
The Docker `network` metricset collects network metrics.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-docker) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "container": {
        "id": "b1c3118fb2087e499c421aa20e28847ad4c185be6c1864166b1a03cc2affaf80",
        "image": {
            "name": "docker.elastic.co/beats/elastic-agent:7.13.0-SNAPSHOT"
        },
        "name": "elastic-package-stack_elastic-agent_1",
        "runtime": "docker"
    },
    "docker": {
        "container": {
            "labels": {
                "com_docker_compose_config-hash": "fdad7f67fafe5a242b9b9d27bff78bef4b96c683a2bb1412d91c32fb5981f2b3",
                "com_docker_compose_container-number": "1",
                "com_docker_compose_oneoff": "False",
                "com_docker_compose_project": "elastic-package-stack",
                "com_docker_compose_project_config_files": "/home/alexk/.elastic-package/stack/openport/snapshot.yml",
                "com_docker_compose_project_working_dir": "/home/alexk/.elastic-package/stack/openport",
                "com_docker_compose_service": "elastic-agent",
                "com_docker_compose_version": "1.27.4",
                "description": "Agent manages other beats based on configuration provided.",
                "io_k8s_description": "Agent manages other beats based on configuration provided.",
                "io_k8s_display-name": "Elastic-Agent image",
                "license": "Elastic License",
                "maintainer": "infra@elastic.co",
                "name": "elastic-agent",
                "org_label-schema_build-date": "2021-04-21T06:45:43Z",
                "org_label-schema_license": "Elastic License",
                "org_label-schema_name": "elastic-agent",
                "org_label-schema_schema-version": "1.0",
                "org_label-schema_url": "https://www.elastic.co/beats/elastic-agent",
                "org_label-schema_vcs-ref": "c52c43963ca8416dc92c7d3dbf6cb6e89dd00acf",
                "org_label-schema_vcs-url": "github.com/elastic/beats/v7",
                "org_label-schema_vendor": "Elastic",
                "org_label-schema_version": "7.13.0-SNAPSHOT",
                "org_opencontainers_image_created": "2021-04-21T06:45:43Z",
                "org_opencontainers_image_licenses": "Elastic License",
                "org_opencontainers_image_title": "Elastic-Agent",
                "org_opencontainers_image_vendor": "Elastic",
                "release": "1",
                "summary": "elastic-agent",
                "url": "https://www.elastic.co/beats/elastic-agent",
                "vendor": "Elastic",
                "version": "7.13.0-SNAPSHOT"
            }
        },
        "network": {
            "in": {
                "bytes": 0,
                "dropped": 0,
                "errors": 0,
                "packets": 0
            },
            "inbound": {
                "bytes": 156469392,
                "dropped": 0,
                "errors": 0,
                "packets": 710866
            },
            "interface": "eth0",
            "out": {
                "bytes": 0,
                "dropped": 0,
                "errors": 0,
                "packets": 0
            },
            "outbound": {
                "bytes": 3150916813,
                "dropped": 0,
                "errors": 0,
                "packets": 1059447
            }
        }
    },
    "event": {
        "dataset": "docker.network",
        "duration": 115000,
        "module": "docker"
    },
    "metricset": {
        "name": "network",
        "period": 10000
    },
    "service": {
        "address": "/var/run/docker.sock",
        "type": "docker"
    }
}
```