﻿---
title: Docker info metricset
description: The Docker info metricset collects system-wide information based on the Docker Remote API. This is a default metricset. If the host module is unconfigured,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-info
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker info metricset
The Docker `info` metricset collects system-wide information based on the [Docker Remote API](https://docs.docker.com/engine/reference/api/docker_remote_api_v1.24/#/display-system-wide-information).
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-docker) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "docker": {
        "info": {
            "containers": {
                "paused": 0,
                "running": 2,
                "stopped": 12,
                "total": 14
            },
            "id": "VF5E:SKD6:YFIG:VDGO:JU3M:ZT2N:4E6B:7IOL:5QOS:M3HT:EM7E:VL22",
            "images": 425
        }
    },
    "event": {
        "dataset": "docker.info",
        "duration": 115000,
        "module": "docker"
    },
    "metricset": {
        "name": "info",
        "period": 10000
    },
    "service": {
        "address": "/var/run/docker.sock",
        "type": "docker"
    }
}
```