﻿---
title: Docker diskio metricset
description: The Docker diskio metricset collects disk I/O metrics. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-diskio
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker diskio metricset
The Docker `diskio` metricset collects disk I/O metrics.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-docker) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "container": {
        "id": "3f2af516565acd770488bc82f55d8ed17b335988f13bb7c5cd3e2dc9abdac6f4",
        "image": {
            "name": "docker.elastic.co/elasticsearch/elasticsearch:8.2.0-SNAPSHOT"
        },
        "name": "elastic-package-stack_elasticsearch_1",
        "runtime": "docker"
    },
    "docker": {
        "diskio": {
            "read": {
                "bytes": 65941504,
                "ops": 0,
                "queued": 0,
                "rate": 0,
                "service_time": 0,
                "wait_time": 0
            },
            "summary": {
                "bytes": 0,
                "ops": 0,
                "queued": 0,
                "rate": 0,
                "service_time": 0,
                "wait_time": 0
            },
            "write": {
                "bytes": 182902059008,
                "ops": 0,
                "queued": 0,
                "rate": 0,
                "service_time": 0,
                "wait_time": 0
            }
        }
    },
    "event": {
        "dataset": "docker.diskio",
        "duration": 115000,
        "module": "docker"
    },
    "metricset": {
        "name": "diskio",
        "period": 10000
    },
    "service": {
        "address": "/var/run/docker.sock",
        "type": "docker"
    }
}
```