﻿---
title: Docker container metricset
description: The Docker container metricset collects information and statistics about running Docker containers. This is a default metricset. If the host module is...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-container
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker container metricset
The Docker `container` metricset collects information and statistics about running Docker containers.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-docker) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "container": {
        "id": "cc78e58acfda4501105dc4de8e3ae218f2da616213e6e3af168c40103829302a",
        "image": {
            "name": "metricbeat_elasticsearch"
        },
        "name": "metricbeat_elasticsearch_1_df866b3a7b3d",
        "runtime": "docker"
    },
    "docker": {
        "container": {
            "command": "/usr/local/bin/docker-entrypoint.sh eswrapper",
            "created": "2019-02-25T10:18:10.000Z",
            "ip_addresses": [
                "172.23.0.2"
            ],
            "labels": {
                "com_docker_compose_config-hash": "e3e0a2c6e5d1afb741bc8b1ecb09cda0395886b7a3e5084a9fd110be46d70f78",
                "com_docker_compose_container-number": "1",
                "com_docker_compose_oneoff": "False",
                "com_docker_compose_project": "metricbeat",
                "com_docker_compose_service": "elasticsearch",
                "com_docker_compose_slug": "df866b3a7b3d50c0802350cbe58ee5b34fa32b7f6ba7fe9e48cde2c12dd0201d",
                "com_docker_compose_version": "1.23.1",
                "license": "Elastic License",
                "org_label-schema_build-date": "20181006",
                "org_label-schema_license": "GPLv2",
                "org_label-schema_name": "elasticsearch",
                "org_label-schema_schema-version": "1.0",
                "org_label-schema_url": "https://www.elastic.co/products/elasticsearch",
                "org_label-schema_vcs-url": "https://github.com/elastic/elasticsearch-docker",
                "org_label-schema_vendor": "Elastic",
                "org_label-schema_version": "6.5.1"
            },
            "size": {
                "root_fs": 0,
                "rw": 0
            },
            "status": "Up 7 minutes (healthy)"
        }
    },
    "event": {
        "dataset": "docker.container",
        "duration": 115000,
        "module": "docker"
    },
    "metricset": {
        "name": "container"
    },
    "service": {
        "address": "/var/run/docker.sock",
        "type": "docker"
    }
}
```