﻿---
title: Couchbase node metricset
description: The Couchbase node metricset collects data from Couchbase pools Rest API http://couchbasehost:8091/pools/default and creates an event for each node in...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-node
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Couchbase node metricset
The Couchbase `node` metricset collects data from Couchbase pools Rest API `http://couchbasehost:8091/pools/default` and creates an event for each node in the cluster.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-couchbase) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "couchbase": {
        "node": {
            "cmd_get": 0,
            "couch": {
                "docs": {
                    "data_size": {
                        "bytes": 9792512
                    },
                    "disk_size": {
                        "bytes": 13563791
                    }
                },
                "spatial": {
                    "data_size": {
                        "bytes": 0
                    },
                    "disk_size": {
                        "bytes": 0
                    }
                },
                "views": {
                    "data_size": {
                        "bytes": 2805219
                    },
                    "disk_size": {
                        "bytes": 2805219
                    }
                }
            },
            "cpu_utilization_rate": {
                "pct": 29.64705882352941
            },
            "current_items": {
                "total": 7303,
                "value": 7303
            },
            "ep_bg_fetched": 0,
            "get_hits": 1.1,
            "hostname": "172.17.0.2:8091",
            "mcd_memory": {
                "allocated": {
                    "bytes": 6377
                },
                "reserved": {
                    "bytes": 6377
                }
            },
            "memory": {
                "free": {
                    "bytes": 4678324224
                },
                "total": {
                    "bytes": 8359174144
                },
                "used": {
                    "bytes": 53962016
                }
            },
            "ops": 1.1,
            "swap": {
                "total": {
                    "bytes": 4189057024
                },
                "used": {
                    "bytes": 135168
                }
            },
            "uptime": {
                "sec": 7260
            },
            "vb_replica_curr_items": 0
        }
    },
    "event": {
        "dataset": "couchbase.node",
        "duration": 115000,
        "module": "couchbase"
    },
    "metricset": {
        "name": "node",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "couchbase"
    }
}
```