﻿---
title: Couchbase cluster metricset
description: The Couchbase cluster metricset collects data from Couchbase pools Rest API http://couchbasehost:8091/pools/default and creates an event containing cluster...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-cluster
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Couchbase cluster metricset
The Couchbase `cluster` metricset collects data from Couchbase pools Rest API `http://couchbasehost:8091/pools/default` and creates an event containing cluster metrics.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-couchbase) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "couchbase": {
        "cluster": {
            "hdd": {
                "free": {
                    "bytes": 46902679716
                },
                "quota": {
                    "total": {
                        "bytes": 63381999616
                    }
                },
                "total": {
                    "bytes": 63381999616
                },
                "used": {
                    "by_data": {
                        "bytes": 16369010
                    },
                    "value": {
                        "bytes": 16479319900
                    }
                }
            },
            "max_bucket_count": 10,
            "quota": {
                "index_memory": {
                    "mb": 300
                },
                "memory": {
                    "mb": 300
                }
            },
            "ram": {
                "quota": {
                    "total": {
                        "per_node": {
                            "bytes": 314572800
                        },
                        "value": {
                            "bytes": 314572800
                        }
                    },
                    "used": {
                        "per_node": {
                            "bytes": 104857600
                        },
                        "value": {
                            "bytes": 104857600
                        }
                    }
                },
                "total": {
                    "bytes": 8359174144
                },
                "used": {
                    "by_data": {
                        "bytes": 53962016
                    },
                    "value": {
                        "bytes": 8004751360
                    }
                }
            }
        }
    },
    "event": {
        "dataset": "couchbase.cluster",
        "duration": 115000,
        "module": "couchbase"
    },
    "metricset": {
        "name": "cluster",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "couchbase"
    }
}
```