﻿---
title: Couchbase bucket metricset
description: The Couchbase bucket metricset collects data from the Couchbase Buckets Rest API http://couchbasehost:8091/pools/default/buckets. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-bucket
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Couchbase bucket metricset
The Couchbase `bucket` metricset collects data from the Couchbase Buckets Rest API `http://couchbasehost:8091/pools/default/buckets`.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-couchbase) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "couchbase": {
        "bucket": {
            "data": {
                "used": {
                    "bytes": 3371588
                }
            },
            "disk": {
                "fetches": 0,
                "used": {
                    "bytes": 9473
                }
            },
            "item_count": 0,
            "memory": {
                "used": {
                    "bytes": 49976304
                }
            },
            "name": "beer-sample",
            "ops_per_sec": 0,
            "quota": {
                "ram": {
                    "bytes": 104857600
                },
                "use": {
                    "pct": 47.66111755371094
                }
            },
            "type": "membase"
        }
    },
    "event": {
        "dataset": "couchbase.bucket",
        "duration": 115000,
        "module": "couchbase"
    },
    "metricset": {
        "name": "bucket"
    },
    "service": {
        "address": "192.168.160.7:8091",
        "type": "couchbase"
    }
}
```