﻿---
title: Containerd memory metricset
description: This is the memory metricset of the module containerd. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-containerd-memory
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Containerd memory metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the memory metricset of the module containerd.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-containerd) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "container": {
        "id": "7434687dbe3684407afa899582f2909203b9dc5537632b512f76798db5c0787d"
    },
    "containerd": {
        "memory": {
            "activeFiles": 1216512,
            "cache": 140980224,
            "inactiveFiles": 139284480,
            "kernel": {
                "fail": {
                    "count": 0
                },
                "limit": 9223372036854772000,
                "max": 6496256,
                "total": 6459392
            },
            "rss": 43794432,
            "swap": {
                "fail": {
                    "count": 0
                },
                "limit": 9223372036854772000,
                "max": 209727488,
                "total": 191959040
            },
            "usage": {
                "fail": {
                    "count": 0
                },
                "limit": 209715200,
                "max": 209608704,
                "pct": 0.9148046875,
                "total": 191848448
            },
            "workingset": {
                "pct": 0.25064453125
            }
        },
        "namespace": "k8s.io"
    },
    "event": {
        "dataset": "containerd.memory",
        "duration": 115000,
        "module": "containerd"
    },
    "metricset": {
        "name": "memory",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "containerd"
    }
}
```