﻿---
title: CockroachDB status metricset
description: The CockroachDB status metricset collects metrics exposed by the Prometheus endpoint of CockroachDB. This is a default metricset. If the host module is...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-cockroachdb-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# CockroachDB status metricset
The CockroachDB `status` metricset collects metrics exposed by the [Prometheus endpoint](https://www.cockroachlabs.com/docs/v2.1/monitoring-and-alerting.html#prometheus-endpoint) of CockroachDB.
<warning>
  This metricset collects a large number of metrics, what can significantly impact disk usage. Processors can be used to drop unused metrics before they are stored. For example the following configuration will drop all histogram buckets:
</warning>

```yaml
- module: cockroachdb
  metricsets: ['status']
  hosts: ['${data.host}:8080']
  processors:
    - drop_event.when.has_fields: ['prometheus.labels.le']
```

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-cockroachdb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp" : "2022-04-08T15:45:24.609Z",
    "agent" : {
      "type" : "metricbeat",
      "version" : "8.2.0",
      "ephemeral_id" : "f5d8484e-b5dd-4045-ab8d-dca751582fae",
      "id" : "ab4d7e17-f770-4672-8e51-acd1386317fb",
      "name" : "example"
    },
    "ecs" : {
      "version" : "8.0.0"
    },
    "prometheus" : {
      "labels" : {
        "instance" : "localhost:8080",
        "job" : "cockroachdb",
        "le" : "8126463"
      },
      "metrics" : {
        "round_trip_latency_bucket" : 22344,
        "exec_latency_bucket" : 279099,
        "sql_txn_latency_internal_bucket" : 19400,
        "sql_exec_latency_internal_bucket" : 62609,
        "sql_service_latency_internal_bucket" : 59879,
        "txn_durations_bucket" : 51573
      }
    },
    "event" : {
      "dataset" : "cockroachdb.status",
      "module" : "cockroachdb",
      "duration" : 48386125
    },
    "metricset" : {
      "name" : "status",
      "period" : 10000
    },
    "service" : {
      "address" : "http://localhost:8080/_status/vars",
      "type" : "cockroachdb"
    }
}
```