﻿---
title: Cloudfoundry value metricset
description: The value metricset of Cloud Foundry module allows you to collect value metrics that the loggregator sends to metricbeat. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-cloudfoundry-value
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Cloudfoundry value metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The value metricset of Cloud Foundry module allows you to collect value metrics that the loggregator sends to metricbeat.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-cloudfoundry) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "cloudfoundry": {
        "envelope": {
            "deployment": "cf-6b7aee31c8d07637ad78",
            "index": "dffd1799-d03a-405a-9309-3fcce23f536f",
            "ip": "192.168.16.15",
            "job": "diego_database",
            "origin": "silk-controller"
        },
        "tags": {
            "source_id": "silk-controller"
        },
        "type": "value",
        "value": {
            "name": "LeasesIndexRequestTime",
            "unit": "ms",
            "value": 0.681265
        }
    },
    "service": {
        "type": "cloudfoundry"
    }
}
```