﻿---
title: Cloudfoundry counter metricset
description: The counter metricset of Cloud Foundry module allows you to collect counter metrics that the loggregator sends to metricbeat. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-cloudfoundry-counter
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Cloudfoundry counter metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The counter metricset of Cloud Foundry module allows you to collect counter metrics that the loggregator sends to metricbeat.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-cloudfoundry) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "cloudfoundry": {
        "counter": {
            "delta": 0,
            "name": "dropped",
            "total": 0
        },
        "envelope": {
            "deployment": "cf-6b7aee31c8d07637ad78",
            "index": "995eb273-f871-4fea-a834-dbc0a4a72efc",
            "ip": "192.168.16.37",
            "job": "syslog_adapter",
            "origin": "loggregator.metron"
        },
        "tags": {
            "direction": "ingress",
            "metric_version": "2.0",
            "product": "Pivotal Application Service",
            "source_id": "metron"
        },
        "type": "counter"
    },
    "service": {
        "type": "cloudfoundry"
    }
}
```