﻿---
title: Cloudfoundry container metricset
description: The container metricset of Cloud Foundry module allows you to collect container metrics that the loggregator sends to metricbeat. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-cloudfoundry-container
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Cloudfoundry container metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The container metricset of Cloud Foundry module allows you to collect container metrics that the loggregator sends to metricbeat.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-cloudfoundry) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "cloudfoundry": {
        "app": {
            "id": "8d165a12-fbd8-40cb-b71a-5bc6086df04c",
            "name": "log-gen"
        },
        "container": {
            "cpu.pct": 4.231873716293137,
            "disk.bytes": 122691584,
            "disk.quota.bytes": 1073741824,
            "instance_index": 3,
            "memory.bytes": 52250065,
            "memory.quota.bytes": 1073741824
        },
        "envelope": {
            "deployment": "cf-9c11cd01425665e2ed6d",
            "index": "9e1a45be-f8a4-44ef-9c34-22f6e51ce4c7",
            "ip": "192.168.16.37",
            "job": "diego_cell",
            "origin": "rep"
        },
        "org": {
            "id": "4af89198-dd33-4542-9915-f489542bc058",
            "name": "elastic-logging-org"
        },
        "space": {
            "id": "10ed1559-e399-4034-babf-6424ef888dc1",
            "name": "logging-space"
        },
        "tags": {
            "instance_id": "3",
            "process_id": "8d165a12-fbd8-40cb-b71a-5bc6086df04c",
            "process_instance_id": "75568c86-b9e0-4330-4784-928b",
            "process_type": "web",
            "product": "VMware Tanzu Application Service",
            "source_id": "8d165a12-fbd8-40cb-b71a-5bc6086df04c"
        },
        "type": "container"
    },
    "service": {
        "type": "cloudfoundry"
    }
}
```