﻿---
title: Ceph cluster_health metricset
description: This is the cluster_health metricset of the Ceph module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-cluster_health
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Ceph cluster_health metricset
This is the `cluster_health` metricset of the Ceph module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-ceph) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "ceph": {
        "cluster_health": {
            "overall_status": "HEALTH_OK",
            "timechecks": {
                "epoch": 3,
                "round": {
                    "status": "finished",
                    "value": 0
                }
            }
        }
    },
    "event": {
        "dataset": "ceph.cluster_health",
        "duration": 115000,
        "module": "ceph"
    },
    "metricset": {
        "name": "cluster_health"
    },
    "service": {
        "address": "127.0.0.1:5000",
        "type": "ceph"
    }
}
```