﻿---
title: Azure container_registry metricset
description: This is the container_registry metricset of the module azure. This metricset allows users to retrieve all metrics from specified container registries...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-azure-container_registry
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Azure container_registry metricset
This is the container_registry metricset of the module azure.
This metricset allows users to retrieve all metrics from specified container registries.

## Metricset-specific configuration notes

<definitions>
  <definition term="refresh_list_interval">
    Resources will be retrieved at each fetch call (`period` interval), this means a number of Azure REST calls will be executed each time. This will be helpful if the azure users will be adding/removing resources that could match the configuration options so they will not added/removed to the list. To reduce on the number of API calls we are executing to retrieve the resources each time, users can configure this setting and make sure the list or resources will not be refreshed as often. This is also beneficial for performance and rate/ cost reasons ([[https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits](https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits)](https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits)).
  </definition>
  <definition term="resources">
    This will contain all options for identifying resources and configuring the desired metrics
  </definition>
</definitions>


### Config options to identify resources

<definitions>
  <definition term="resource_id">
    (*[]string*) The fully qualified ID’s of the resource, including the resource name and resource type. Has the format `/subscriptions/{{guid}}/resourceGroups/{{resource-group-name}}/providers/{{resource-provider-namespace}}/{resource-type}/{{resource-name}}`. Should return a list of resources.
  </definition>
  <definition term="resource_group">
    (*[]string*) This option will return all container registries inside the resource group.
  </definition>
</definitions>

If none of the options are entered then all container registries from the entire subscription are taken in account. For each metric the primary aggregation assigned will be retrieved. A default non configurable timegrain of 5 min is set so users are advised to configure an interval of 300s or  a multiply of it.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-azure) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "azure": {
        "container_registry": {
            "successful_pull_count": {
                "avg": 1
            },
            "successful_push_count": {
                "avg": 1
            },
            "total_pull_count": {
                "avg": 1
            },
            "total_push_count": {
                "avg": 1
            }
        },
        "namespace": "Microsoft.ContainerRegistry/registries",
        "resource": {
            "group": "obs-infrastructure",
            "type": "Microsoft.ContainerRegistry/registries",
            "id": "/subscriptions/fd675b6f-b5e5-426e-ac45-d1f876d0ffa6/resourceGroups/obs-infrastructure/providers/Microsoft.ContainerRegistry/registries/obstest",
            "name": "obstest"
        },
        "subscription_id": "fd675b6f-b5e5-426e-ac45-d1f876d0ffa6",
        "timegrain": "PT5M"
    },
    "cloud": {
        "provider": "azure",
        "region": "westeurope"
    },
    "event": {
        "dataset": "azure.container_registry",
        "duration": 115000,
        "module": "azure"
    },
    "metricset": {
        "name": "container_registry",
        "period": 10000
    },
    "service": {
        "type": "azure"
    }
}
```