﻿---
title: Azure billing metricset
description: This is the billing metricset of the module azure. This metricset allows users to retrieve usage details and forecast information of the subscription...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-azure-billing
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Azure billing metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the billing metricset of the module azure.
This metricset allows users to retrieve usage details and forecast information of the subscription configured.

## Metricset-specific configuration notes

<definitions>
  <definition term="refresh_list_interval">
    Resources will be retrieved at each fetch call (`period` interval), this means a number of Azure REST calls will be executed each time. This will be helpful if the azure users will be adding/removing resources that could match the configuration options so they will not added/removed to the list. To reduce on the number of API calls we are executing to retrieve the resources each time, users can configure this setting and make sure the list or resources will not be refreshed as often. This is also beneficial for performance and rate/ cost reasons ([[https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits](https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits)](https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-request-limits)).
  </definition>
  <definition term="resources">
    This will contain all options for identifying resources and configuring the desired metrics
  </definition>
</definitions>


### Config options to identify resources

<definitions>
  <definition term="billing_scope_department">
    (*string*) Retrieve usage details based on the department scope.
  </definition>
  <definition term="billing_scope_account_id">
    (*string*) Retrieve usage details based on the billing account ID scope.
  </definition>
</definitions>

If none of the 2 options are entered then the subscription ID will be used as scope.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-azure) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2020-07-08T08:05:34.853Z",
    "azure": {
        "billing" : {
            "product" : "Tables - LRS Data Stored",
            "usage_start" : "2020-07-08T00:00:00.000Z",
            "usage_end" : "2020-07-08T23:59:59.000Z",
            "currency" : "USD",
            "billing_period_id" : "/subscriptions/fd675b6f-b5e5-426e-ac45-d1f876d0ffa6/providers/Microsoft.Billing/billingPeriods/20200701",
            "account_name" : "Eng1",
            "pretax_cost" : "0.000004175936293",
            "department_name" : "Eng"
        },
        "resource": {
            "group": "obs-infrastructure"
        },
        "subscription_id": "fd675b6f-b5e5-426e-ac45-d1f876d0ffa6"
    },
    "cloud": {
        "instance": {
            "id": "/subscriptions/fd675b6f-b5e5-426e-ac45-d1f876d0ffa6/resourceGroups/obs-infrastructure/providers/Microsoft.DocumentDb/databaseAccounts/obsaccount",
            "name": "obsaccount"
        },
        "provider": "azure",
        "region": "westeurope"
    },
    "event": {
        "dataset": "azure.monitor",
        "duration": 115000,
        "module": "azure"
    },
    "metricset": {
        "name": "monitor",
        "period": 10000
    },
    "service": {
        "type": "azure"
    }
}
```