﻿---
title: Azure app_state metricset
description: This is the app_state metricset of the module azure. This metricset allows users to retrieve application insights metrics from specified applications...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-azure-app_state
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Azure app_state metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the app_state metricset of the module azure.
This metricset allows users to retrieve application insights metrics from specified applications.

### Config options to identify resources

<definitions>
  <definition term="application_id">
    (*[]string*) ID of the application. This is Application ID from the API Access settings blade in the Azure portal.
  </definition>
  <definition term="api_key">
    (*[]string*) The API key which will be generated, more on the steps here [[https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID](https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID)](https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID).
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-azure) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "azure": {
        "app_state": {
            "end_date": "2020-10-02T13:23:11.221Z",
            "requests_count": {
                "sum": 16
            },
            "start_date": "2020-10-01T13:23:11.221Z"
        },
        "application_id": "42cb59a9-d5be-400b-a5c4-69b0a00434fdf4",
        "dimensions": {
            "request_name": "GET /auth",
            "request_url_host": "demoapplogobs.azurewebsites.net"
        }
    },
    "cloud": {
        "provider": "azure"
    },
    "event": {
        "dataset": "azure.app_state",
        "duration": 115000,
        "module": "azure"
    },
    "metricset": {
        "name": "app_state",
        "period": 10000
    },
    "service": {
        "type": "azure"
    }
}
```