﻿---
title: Azure app_insights metricset
description: This is the app_insights metricset. This metricset allows users to retrieve application insights metrics from specified applications. Example configuration:...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-azure-app_insights
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Azure app_insights metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the app_insights metricset.
This metricset allows users to retrieve application insights metrics from specified applications.

### Config options to identify resources

<definitions>
  <definition term="application_id">
    (*[]string*) ID of the application. This is Application ID from the API Access settings blade in the Azure portal.
  </definition>
  <definition term="api_key">
    (*[]string*) The API key which will be generated, more on the steps here [[https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID](https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID)](https://dev.applicationinsights.io/documentation/Authorization/API-key-and-App-ID).
  </definition>
</definitions>


### App insights metric configurations

<definitions>
  <definition term="metrics">
    List of different metrics to collect information
  </definition>
  <definition term="id">
    (*[]string*) IDs of the metrics that’s being reported. Usually, the id is descriptive enough to help identify what’s measured. A list of metric names can be entered as well. Default metricsets include: `requests/count` `requests/duration` `requests/failed` `users/count``users/authenticated` `pageViews/count` `pageViews/duration` `customEvents/count` `browserTimings/processingDuration` `browserTimings/receiveDuration` `browserTimings/networkDuration` `browserTimings/sendDuration` `browserTimings/totalDuration` `dependencies/count` `dependencies/duration` `dependencies/failed` `exceptions/count` `exceptions/browser` `exceptions/server` `sessions/count` `performanceCounters/requestExecutionTime` `performanceCounters/requestsPerSecond` `performanceCounters/requestsInQueue` `performanceCounters/memoryAvailableBytes` `performanceCounters/exceptionsPerSecond` `performanceCounters/processCpuPercentage` `performanceCounters/processIOBytesPerSecond` `performanceCounters/processPrivateBytes` `performanceCounters/processorCpuPercentage` `availabilityResults/count` `availabilityResults/availabilityPercentage` `availabilityResults/duration`
  </definition>
  <definition term="interval">
    (*string*) The time interval to use when retrieving metric values. This is an ISO8601 duration. If interval is omitted, the metric value is aggregated across the entire timespan. If interval is supplied, the result may adjust the interval to a more appropriate size based on the timespan used for the query.
  </definition>
  <definition term="aggregation">
    (*[]string*) The aggregation to use when computing the metric values. To retrieve more than one aggregation at a time, separate them with a comma. If no aggregation is specified, then the default aggregation for the metric is used.
  </definition>
  <definition term="segment">
    (*[]string*) The name of the dimension to segment the metric values by. This dimension must be applicable to the metric you are retrieving. In this case, the metric data will be segmented in the order the dimensions are listed in the parameter.
  </definition>
  <definition term="top">
    (*int*) The number of segments to return. This value is only valid when segment is specified.
  </definition>
  <definition term="order_by">
    (*string*) The aggregation function and direction to sort the segments by. This value is only valid when segment is specified.
  </definition>
  <definition term="filter">
    (*string*) An expression used to filter the results. This value should be a valid OData filter expression where the keys of each clause should be applicable dimensions for the metric you are retrieving.
  </definition>
</definitions>

Example configuration:
```yaml
metrics:
 - id: ["requests/count", "requests/failed"]
   segment: "request/name"
   aggregation: ["sum"]
```


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-azure) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "azure": {
        "app_insights": {
            "end_date": "2020-10-02T13:17:45.691Z",
            "start_date": "2020-10-02T13:12:45.691Z"
        },
        "application_id": "42cb59a9-d5be-400b-a5c4-69b0a00434fdf4",
        "metrics": {
            "requests_count": {
                "sum": 0
            }
        }
    },
    "cloud": {
        "provider": "azure"
    },
    "event": {
        "dataset": "azure.app_insights",
        "duration": 115000,
        "module": "azure"
    },
    "metricset": {
        "name": "app_insights",
        "period": 10000
    },
    "service": {
        "type": "azure"
    }
}
```