﻿---
title: AWS usage metricset
description: The usage metricset of aws module allows you to collects metrics that track the usage of some AWS resources by querying AWS Cloudwatch API. Usage metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-usage
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# AWS usage metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The usage metricset of aws module allows you to collects metrics that track the usage of some AWS resources by querying AWS Cloudwatch API. Usage metrics correspond to AWS service quotas and tracking these metrics can help users to manage quotas proactively. Service quota usage metrics are collected by Cloudwatch every minute. Therefore, 1-minute is the recommended period for this metricset.

## AWS Permissions

Some specific AWS permissions are required for IAM user to collect usage metrics.
```
ec2:DescribeRegions
cloudwatch:GetMetricData
cloudwatch:ListMetrics
tag:getResources
sts:GetCallerIdentity
iam:ListAccountAliases
```


## Dashboard

The aws usage metricset comes with a predefined dashboard. For example:
![metricbeat aws usage overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aws-usage-overview.png)

## Configuration example

```yaml
- module: aws
  period: 1m
  metricsets:
    - usage
  # This module uses the aws cloudwatch metricset, all
  # the options for this metricset are also available here.
```


## Metrics and Dimensions

Metrics:

| Metric Name | Statistic Method | Description                                                   |
|-------------|------------------|---------------------------------------------------------------|
| CallCount   | Sum              | The number of specified operations performed in your account. |

Dimensions:

| Dimension Name | Description                                                                                                |
|----------------|------------------------------------------------------------------------------------------------------------|
| Resource       | The name of the API operation.                                                                             |
| Service        | The name of the AWS service containing the resource.                                                       |
| Type           | The type of resource being tracked. Currently, the only valid value is API.                                |
| Class          | The class of resource being tracked. CloudWatch API usage metrics use this dimension with a value of None. |

Please see [CloudWatch Usage Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Usage-Metrics.html) for more details.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "cloudwatch": {
            "namespace": "AWS/Usage"
        },
        "dimensions": {
            "Class": "None",
            "Resource": "AccountProvisionedWriteCapacityUnits",
            "Service": "DynamoDB",
            "Type": "Resource"
        },
        "usage": {
            "metrics": {
                "ResourceCount": {
                    "sum": 45
                }
            }
        }
    },
    "cloud": {
        "account": {
            "id": "428152502467",
            "name": "elastic-beats"
        },
        "provider": "aws",
        "region": "eu-central-1"
    },
    "event": {
        "dataset": "aws.usage",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "usage",
        "period": 10000
    },
    "service": {
        "type": "aws"
    }
}
```