﻿---
title: AWS sqs metricset
description: The sqs metricset of aws module allows you to monitor your AWS SQS queues. sqs metricset fetches a set of values from Amazon SQS Metrics. CloudWatch metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-sqs
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# AWS sqs metricset
The sqs metricset of aws module allows you to monitor your AWS SQS queues. `sqs` metricset fetches a set of values from [Amazon SQS Metrics](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-available-cloudwatch-metrics.html). CloudWatch metrics for Amazon SQS queues are automatically collected and pushed to CloudWatch every five minutes.

## AWS Permissions

Some specific AWS permissions are required for IAM user to collect AWS SQS metrics.
```
cloudwatch:GetMetricData
cloudwatch:ListMetrics
ec2:DescribeRegions
sqs:ListQueues
sts:GetCallerIdentity
iam:ListAccountAliases
```


## Dashboard

The aws sqs metricset comes with a predefined dashboard. For example:
![metricbeat aws sqs overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aws-sqs-overview.png)

## Configuration example

```yaml
- module: aws
  period: 300s
  metricsets:
    - sqs
  access_key_id: '<access_key_id>'
  secret_access_key: '<secret_access_key>'
  session_token: '<session_token>'
```

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "cloudwatch": {
            "namespace": "AWS/SQS"
        },
        "dimensions": {
            "QueueName": "filebeat-aws-elb-test"
        },
        "sqs": {
            "empty_receives": 0,
            "messages": {
                "delayed": 0,
                "deleted": 0,
                "not_visible": 0,
                "received": 0,
                "sent": 0,
                "visible": 1577.8
            },
            "oldest_message_age": {
                "sec": 345603.2
            },
            "queue": {
                "name": "filebeat-aws-elb-test"
            }
        },
        "tags": {
            "created-by": "kaiyan"
        }
    },
    "cloud": {
        "account": {
            "id": "428152502467",
            "name": "elastic-beats"
        },
        "provider": "aws",
        "region": "eu-central-1"
    },
    "event": {
        "dataset": "aws.sqs",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "sqs",
        "period": 10000
    },
    "service": {
        "type": "aws"
    }
}
```