﻿---
title: AWS lambda metricset
description: AWS Lambda monitors functions and sends metrics to Amazon CloudWatch. These metrics include total invocations, errors, duration, throttles, dead-letter...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-lambda
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# AWS lambda metricset
AWS Lambda monitors functions and sends metrics to Amazon CloudWatch. These metrics include total invocations, errors, duration, throttles, dead-letter queue errors, and iterator age for stream-based invocations.

## AWS Permissions

Some specific AWS permissions are required for IAM user to collect AWS EBS metrics.
```
ec2:DescribeRegions
cloudwatch:GetMetricData
cloudwatch:ListMetrics
tag:getResources
sts:GetCallerIdentity
iam:ListAccountAliases
```


## Dashboard

The aws lambda metricset comes with a predefined dashboard. For example:
![metricbeat aws lambda overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aws-lambda-overview.png)

## Configuration example

```yaml
- module: aws
  period: 300s
  metricsets:
    - lambda
  # This module uses the aws cloudwatch metricset, all
  # the options for this metricset are also available here.
```


## Metrics

Please see more details for each metric in [lambda-cloudwatch-metric](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions-metrics.html).

| Metric Name                                | Statistic Method |
|--------------------------------------------|------------------|
| Invocations                                | Average          |
| Errors                                     | Average          |
| DeadLetterErrors                           | Average          |
| DestinationDeliveryFailures                | Average          |
| Duration                                   | Average          |
| Throttles                                  | Average          |
| IteratorAge                                | Average          |
| ConcurrentExecutions                       | Average          |
| UnreservedConcurrentExecutions             | Average          |
| ProvisionedConcurrentExecutions            | Maximum          |
| ProvisionedConcurrencyInvocations          | Sum              |
| ProvisionedConcurrencySpilloverInvocations | Sum              |
| ProvisionedConcurrencyUtilization          | Maximum          |

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "cloudwatch": {
            "namespace": "AWS/Lambda"
        },
        "dimensions": {
            "FunctionName": "ec2-owner-tagger-serverless",
            "Resource": "ec2-owner-tagger-serverless"
        },
        "lambda": {
            "metrics": {
                "Duration": {
                    "avg": 8218.073333333334
                },
                "Errors": {
                    "avg": 1
                },
                "Invocations": {
                    "avg": 1
                },
                "Throttles": {
                    "avg": 0
                }
            }
        }
    },
    "cloud": {
        "account": {
            "id": "627959692251",
            "name": "elastic-test"
        },
        "provider": "aws",
        "region": "us-west-2"
    },
    "event": {
        "dataset": "aws.lambda",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "lambda",
        "period": 10000
    },
    "service": {
        "type": "aws"
    }
}
```