﻿---
title: AWS elb metricset
description: Elastic Load Balancing publishes data points to Amazon CloudWatch for your load balancers and your back-end instances. This aws elb metricset collects...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-elb
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# AWS elb metricset
Elastic Load Balancing publishes data points to Amazon CloudWatch for your load balancers and your back-end instances. This aws `elb` metricset collects these Cloudwatch metrics for monitoring purposes.

## AWS Permissions

Some specific AWS permissions are required for IAM user to collect AWS ELB metrics.
```
ec2:DescribeRegions
cloudwatch:GetMetricData
cloudwatch:ListMetrics
tag:getResources
sts:GetCallerIdentity
iam:ListAccountAliases
```


## Dashboard

The aws elb metricset comes with a predefined dashboard for classic ELB. For example:
![metricbeat aws elb overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aws-elb-overview.png)

## Configuration example

```yaml
- module: aws
  period: 300s
  metricsets:
    - elb
  access_key_id: '${AWS_ACCESS_KEY_ID:""}'
  secret_access_key: '${AWS_SECRET_ACCESS_KEY:""}'
  session_token: '${AWS_SESSION_TOKEN:""}'
  # This module uses the aws cloudwatch metricset, all
  # the options for this metricset are also available here.
```


## Metrics

elb metricset collects Cloudwatch metrics from [classic ELB](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-cloudwatch-metrics.html), [application ELB](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-cloudwatch-metrics.html) and [network ELB](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-cloudwatch-metrics.html).

### Metrics for Classic ELB


| Metric Name                       | Statistic Method |
|-----------------------------------|------------------|
| BackendConnectionErrors           | Sum              |
| HealthyHostCount                  | Maximum          |
| HTTPCode_Backend_2XX              | Sum              |
| HTTPCode_Backend_3XX              | Sum              |
| HTTPCode_Backend_4XX              | Sum              |
| HTTPCode_Backend_5XX              | Sum              |
| HTTPCode_ELB_4XX                  | Sum              |
| HTTPCode_ELB_5XX                  | Sum              |
| Latency                           | Average          |
| RequestCount                      | Sum              |
| SpilloverCount                    | Sum              |
| SurgeQueueLength                  | Maximum          |
| UnHealthyHostCount                | Maximum          |
| EstimatedALBActiveConnectionCount | Average          |
| EstimatedALBConsumedLCUs          | Average          |
| EstimatedALBNewConnectionCount    | Average          |
| EstimatedProcessedBytes           | Average          |


### Metrics for Application ELB


| Metric Name                            | Statistic Method |
|----------------------------------------|------------------|
| ActiveConnectionCount                  | Sum              |
| ClientTLSNegotiationErrorCount         | Sum              |
| ConsumedLCUs                           | Average          |
| HTTP_Fixed_Response_Count              | Sum              |
| HTTP_Redirect_Count                    | Sum              |
| HTTP_Redirect_Url_Limit_Exceeded_Count | Sum              |
| HTTPCode_ELB_3XX_Count                 | Sum              |
| HTTPCode_ELB_4XX_Count                 | Sum              |
| HTTPCode_ELB_5XX_Count                 | Sum              |
| HTTPCode_ELB_500_Count                 | Sum              |
| HTTPCode_ELB_502_Count                 | Sum              |
| HTTPCode_ELB_503_Count                 | Sum              |
| HTTPCode_ELB_504_Count                 | Sum              |
| IPv6ProcessedBytes                     | Sum              |
| IPv6RequestCount                       | Sum              |
| NewConnectionCount                     | Sum              |
| ProcessedBytes                         | Sum              |
| RejectedConnectionCount                | Sum              |
| RequestCount                           | Sum              |
| RuleEvaluations                        | Sum              |


### Metrics for Network ELB


| Metric Name                    | Statistic Method |
|--------------------------------|------------------|
| ActiveFlowCount                | Average          |
| ActiveFlowCount_TLS            | Average          |
| ActiveFlowCount_TCP            | Average          |
| ActiveFlowCount_UDP            | Average          |
| ConsumedLCUs                   | Average          |
| ConsumedLCUs_TCP               | Average          |
| ConsumedLCUs_TLS               | Average          |
| ConsumedLCUs_UDP               | Average          |
| ClientTLSNegotiationErrorCount | Sum              |
| NewFlowCount                   | Sum              |
| NewFlowCount_TLS               | Sum              |
| NewFlowCount_TCP               | Sum              |
| NewFlowCount_UDP               | Sum              |
| ProcessedBytes                 | Sum              |
| ProcessedBytes_TCP             | Sum              |
| ProcessedBytes_TLS             | Sum              |
| ProcessedBytes_UDP             | Sum              |
| TargetTLSNegotiationErrorCount | Sum              |
| TCP_Client_Reset_Count         | Sum              |
| TCP_ELB_Reset_Count            | Sum              |
| TCP_Target_Reset_Count         | Sum              |
| UnHealthyHostCount             | Maximum          |
| HealthyHostCount               | Maximum          |

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "cloudwatch": {
            "namespace": "AWS/ELB"
        },
        "dimensions": {
            "Namespace": "AWS"
        },
        "elb": {
            "metrics": {
                "HealthyHostCount": {
                    "max": 2
                },
                "Latency": {
                    "avg": 0.000005960464477539062
                },
                "RequestCount": {
                    "sum": 1
                },
                "SurgeQueueLength": {
                    "max": 1
                },
                "UnHealthyHostCount": {
                    "max": 0
                }
            }
        }
    },
    "cloud": {
        "account": {
            "id": "428152502467",
            "name": "elastic-beats"
        },
        "provider": "aws",
        "region": "us-east-1"
    },
    "event": {
        "dataset": "aws.elb",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "elb",
        "period": 10000
    },
    "service": {
        "type": "aws"
    }
}
```