﻿---
title: AWS ebs metricset
description: Amazon Elastic Block Store (Amazon EBS) sends data points to CloudWatch for several metrics. Most EBS volumes automatically send five-minute metrics to...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-ebs
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# AWS ebs metricset
Amazon Elastic Block Store (Amazon EBS) sends data points to CloudWatch for several metrics. Most EBS volumes automatically send five-minute metrics to CloudWatch only when the volume is attached to an instance. This aws `ebs` metricset collects these Cloudwatch metrics for monitoring purposes.

## AWS Permissions

Some specific AWS permissions are required for IAM user to collect AWS EBS metrics.
```
ec2:DescribeRegions
cloudwatch:GetMetricData
cloudwatch:ListMetrics
tag:getResources
sts:GetCallerIdentity
iam:ListAccountAliases
```


## Dashboard

The aws ebs metricset comes with a predefined dashboard. For example:
![metricbeat aws ebs overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aws-ebs-overview.png)

## Configuration example

```yaml
- module: aws
  period: 300s
  metricsets:
    - ebs
  # This module uses the aws cloudwatch metricset, all
  # the options for this metricset are also available here.
```


## Metrics

Please see more details for each metric in [ebs-cloudwatch-metric](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html).

| Metric Name                | Statistic Method |
|----------------------------|------------------|
| VolumeReadBytes            | Average          |
| VolumeWriteBytes           | Average          |
| VolumeReadOps              | Average          |
| VolumeWriteOps             | Average          |
| VolumeQueueLength          | Average          |
| VolumeThroughputPercentage | Average          |
| VolumeConsumedReadWriteOps | Average          |
| BurstBalance               | Average          |
| VolumeTotalReadTime        | Sum              |
| VolumeTotalWriteTime       | Sum              |
| VolumeIdleTime             | Sum              |

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "cloudwatch": {
            "namespace": "AWS/EBS"
        },
        "dimensions": {
            "VolumeId": "vol-0dac7d6bb8e24ba7c"
        },
        "ebs": {
            "metrics": {
                "VolumeIdleTime": {
                    "sum": 299.97
                },
                "VolumeQueueLength": {
                    "avg": 0.000166666666666667
                },
                "VolumeReadOps": {
                    "avg": 0
                },
                "VolumeTotalWriteTime": {
                    "sum": 0.05
                },
                "VolumeWriteBytes": {
                    "avg": 4915.2
                },
                "VolumeWriteOps": {
                    "avg": 30
                }
            }
        }
    },
    "cloud": {
        "account": {
            "id": "627959692251",
            "name": "elastic-test"
        },
        "provider": "aws",
        "region": "eu-central-1"
    },
    "event": {
        "dataset": "aws.ebs",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "ebs",
        "period": 10000
    },
    "service": {
        "type": "aws"
    }
}
```