﻿---
title: AWS awshealth metricset
description: AWS Health metrics provide insights into the health of your AWS environment by monitoring various aspects such as open issues, scheduled maintenance events,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aws-awshealth
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# AWS awshealth metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

AWS Health metrics provide insights into the health of your AWS environment by monitoring various aspects such as open issues, scheduled maintenance events, security advisories, compliance status, notification counts, and service disruptions. These metrics help you proactively identify and address issues impacting your AWS resources, ensuring the reliability, security, and compliance of your infrastructure.

## AWS Permissions

To collect AWS Health metrics using Elastic Metricbeat, you would need specific AWS permissions to access the necessary data. Here’s a list of permissions required for an IAM user to collect AWS Health metrics:
```
health:DescribeAffectedEntities
health:DescribeEventDetails
health:DescribeEvents
```


## Configuration example

```yaml
- module: aws
  period: 24h
  metricsets:
    - awshealth
```

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aws) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aws": {
        "awshealth": {
            "affected_entities": [
                {
                    "aws_account_id": "12301234013123",
                    "entity_url": "",
                    "entity_value": "arn:aws:eks:us-east-2:627286350134:cluster/XXXXXXXXXXXXX",
                    "last_updated_time": "2024-04-12T12:56:29.7Z",
                    "status_code": "PENDING",
                    "entity_arn": "arn:aws:health:us-east-2:627286350134:entity/YYYYYYYYYYYYYYYYYYYY"
                }
            ],
            "affected_entities_others": 0,
            "affected_entities_pending": 1,
            "affected_entities_resolved": 0,
            "end_time": "0001-01-01T00:00:00Z",
            "event_arn": "arn:aws:health:us-east-2::event/EKS/AWS_EKS_PLANNED_LIFECYCLE_EVENT/AWS_EKS_PLANNED_LIFECYCLE_EVENT_a7e64e77680080d19971a80f0131ff2239909cdbe7647dd57710b764b988f476",
            "event_description": "On May 1, 2024, standard support for Kubernetes version 1.25 in Amazon EKS will end. From May 2, 2024 all Amazon EKS clusters running on 1.25 will enter extended support and will remain in extended support until May 1, 2025.\n\nAfter May 1, 2025, Kubernetes 1.25 will no longer be supported on Amazon EKS, and all Amazon EKS clusters running on 1.25 will be automatically updated to Kubernetes version 1.26.\n\nYou are receiving this message because you currently have 1 or more Amazon EKS clusters running on Kubernetes version 1.25. A list of your impacted clusters can be found in the \"Affected resources\" tab.\n\nExtended support is currently in free preview and is available to all customers. Effective April 1 2024, your Amazon EKS clusters running on a Kubernetes version in extended support will be charged at $0.60 per cluster hour.\n\nIf you do not want to use extended support, we recommend that you update your 1.25 clusters to Kubernetes version 1.26 or newer before May 1, 2024. To learn more about the extended support for Kubernetes versions pricing, see our announcement [1]. For instructions on how to update your cluster(s), see the Amazon EKS service 'Updating an Amazon EKS cluster Kubernetes version' documentation [2].\n\nTo learn more on Kubernetes version support, see the 'Amazon EKS Kubernetes versions' documentation [3].\n\nFor any questions or assistance, please contact AWS Support [4].\n\n\n[1] https://aws.amazon.com/blogs/containers/amazon-eks-extended-support-for-kubernetes-versions-pricing/\n[2] https://docs.aws.amazon.com/eks/latest/userguide/update-cluster.html\n[3] https://docs.aws.amazon.com/eks/latest/userguide/kubernetes-versions.html\n[4] https://aws.amazon.com/support",
            "event_scope_code": "ACCOUNT_SPECIFIC",
            "event_type_category": "scheduledChange",
            "event_type_code": "AWS_EKS_PLANNED_LIFECYCLE_EVENT",
            "last_updated_time": "2024-04-12T13:12:39.273Z",
            "region": "us-east-2",
            "service": "EKS",
            "start_time": "2024-05-01T07:00:00Z",
            "status_code": "upcoming"
        }
    },
    "cloud.provider": "aws",
    "event": {
        "dataset": "aws.awshealth",
        "duration": 115000,
        "module": "aws"
    },
    "metricset": {
        "name": "awshealth",
        "period": 10000
    },
    "service": {
        "type": "aws-health"
    }
}
```