﻿---
title: Apache status metricset
description: The Apache status metricset collects data from the Apache mod_status module. It scrapes the server status data from the web page generated by mod_status...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-apache-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Apache status metricset
The Apache `status` metricset collects data from the Apache [mod_status](https://httpd.apache.org/docs/current/mod/mod_status.html) module. It scrapes the server status data from the web page generated by mod_status.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-apache) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "apache": {
        "status": {
            "bytes_per_request": 112.913,
            "bytes_per_sec": 103.832,
            "connections": {
                "async": {
                    "closing": 0,
                    "keep_alive": 0,
                    "writing": 0
                },
                "total": 0
            },
            "cpu": {
                "children_system": 0,
                "children_user": 0,
                "load": 0.125874,
                "system": 0.2,
                "user": 0.16
            },
            "load": {
                "1": 2,
                "15": 1.91,
                "5": 1.85
            },
            "requests_per_sec": 0.91958,
            "scoreboard": {
                "closing_connection": 0,
                "dns_lookup": 0,
                "gracefully_finishing": 0,
                "idle_cleanup": 0,
                "keepalive": 0,
                "logging": 0,
                "open_slot": 325,
                "reading_request": 0,
                "sending_reply": 1,
                "starting_up": 0,
                "total": 400,
                "waiting_for_connection": 74
            },
            "total_accesses": 263,
            "total_kbytes": 29,
            "uptime": {
                "server_uptime": 286,
                "uptime": 286
            },
            "workers": {
                "busy": 1,
                "idle": 74
            }
        }
    },
    "event": {
        "dataset": "apache.status",
        "duration": 115000,
        "module": "apache"
    },
    "metricset": {
        "name": "status",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "apache"
    }
}
```