﻿---
title: Airflow statsd metricset
description: Statsd Metricset retrieves the Airflow metrics using Statsd. This is a default metricset. If the host module is unconfigured, this metricset is enabled...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-airflow-statsd
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Airflow statsd metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Statsd Metricset retrieves the Airflow metrics using Statsd.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-airflow) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "airflow": {
        "dag_duration": {
            "15m_rate": 0,
            "1m_rate": 0,
            "5m_rate": 0,
            "count": 1,
            "max": 200,
            "mean": 200,
            "mean_rate": 38960.532980091164,
            "median": 200,
            "min": 200,
            "p75": 200,
            "p95": 200,
            "p99": 200,
            "p99_9": 200,
            "stddev": 0
        },
        "dag_id": "a_dagid",
        "status": "failure"
    },
    "event": {
        "dataset": "statsd",
        "module": "airflow"
    },
    "labels": {
        "k1": "v1",
        "k2": "v2"
    },
    "service": {
        "type": "airflow"
    }
}
```