﻿---
title: Aerospike namespace metricset
description: This is the namespace metricset of the Aerospike module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aerospike-namespace
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Aerospike namespace metricset
This is the `namespace` metricset of the Aerospike module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-aerospike) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "aerospike": {
        "namespace": {
            "client": {
                "delete": {
                    "error": 0,
                    "not_found": 0,
                    "success": 0,
                    "timeout": 0
                },
                "read": {
                    "error": 0,
                    "not_found": 0,
                    "success": 0,
                    "timeout": 0
                },
                "write": {
                    "error": 0,
                    "success": 0,
                    "timeout": 0
                }
            },
            "device": {
                "available": {
                    "pct": 99
                },
                "free": {
                    "pct": 100
                },
                "total": {
                    "bytes": 4294967296
                },
                "used": {
                    "bytes": 0
                }
            },
            "hwm_breached": false,
            "memory": {
                "free": {
                    "pct": 100
                },
                "used": {
                    "data": {
                        "bytes": 0
                    },
                    "index": {
                        "bytes": 0
                    },
                    "sindex": {
                        "bytes": 0
                    },
                    "total": {
                        "bytes": 0
                    }
                }
            },
            "name": "test",
            "node": {
                "host": "172.26.0.2:3000",
                "name": "BB902001AAC4202"
            },
            "objects": {
                "master": 0,
                "total": 0
            },
            "stop_writes": false
        }
    },
    "event": {
        "dataset": "aerospike.namespace",
        "duration": 115000,
        "module": "aerospike"
    },
    "metricset": {
        "name": "namespace"
    },
    "service": {
        "address": "172.26.0.2:3000",
        "type": "aerospike"
    }
}
```