﻿---
title: ActiveMQ topic metricset
description: This is the topic metricset of the ActiveMQ module. The metricset provides metrics describing the available ActiveMQ topics, especially exchanged messages...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-activemq-topic
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ActiveMQ topic metricset
This is the `topic` metricset of the ActiveMQ module.
The metricset provides metrics describing the available ActiveMQ topics, especially exchanged messages (enqueued, dequeued, expired, in-flight), connected consumers and producers.
To collect data, the module communicates with a Jolokia HTTP/REST endpoint that exposes the JMX metrics over HTTP/REST/JSON (JMX key: `org.apache.activemq:brokerName=localhost,destinationName=sample_queue,destinationType=Queue,type=Broker`).
The topic metricset comes with a predefined dashboard:
![metricbeat activemq topics overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-activemq-topics-overview.png)
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-activemq) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-11-19T13:14:29.796Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "service": {
        "type": "activemq",
        "address": "localhost:33051"
    },
    "activemq": {
        "topic": {
            "name": "sample_topic",
            "memory": {
                "broker": {
                    "pct": 0
                }
            },
            "mbean": "org.apache.activemq:brokerName=localhost,destinationName=sample_topic,destinationType=Topic,type=Broker",
            "producers": {
                "count": 0
            },
            "consumers": {
                "count": 0
            },
            "messages": {
                "inflight": {
                    "count": 0
                },
                "expired": {
                    "count": 0
                },
                "enqueue": {
                    "time": {
                        "max": 0,
                        "avg": 0,
                        "min": 0
                    },
                    "count": 2
                },
                "dequeue": {
                    "count": 0
                },
                "dispatch": {
                    "count": 0
                },
                "size": {
                    "avg": 1037
                }
            }
        }
    },
    "ecs": {
        "version": "1.2.0"
    },
    "host": {
        "name": "macbook.local"
    },
    "agent": {
        "version": "8.0.0",
        "type": "metricbeat",
        "ephemeral_id": "99de94c0-c183-438d-9751-428e3ea3bbbd",
        "hostname": "macbook.local",
        "id": "8d20f9a9-b24d-419b-97e6-bcccfb64679c"
    },
    "event": {
        "dataset": "activemq.topic",
        "module": "activemq",
        "duration": 34431327
    },
    "metricset": {
        "period": 5000,
        "name": "topic"
    }
}
```