﻿---
title: Metricbeat quick start: installation and configuration
description: Metricbeat helps you monitor your servers and the services they host by collecting metrics from the operating system and services. This guide describes...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Metricbeat quick start: installation and configuration
Metricbeat helps you monitor your servers and the services they host by collecting metrics from the operating system and services.
This guide describes how to get started quickly with metrics collection. You’ll learn how to:
- install Metricbeat on each system you want to monitor
- specify the metrics you want to collect
- send the metrics to Elasticsearch
- visualize the metrics data in Kibana

![Metricbeat System dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-system-dashboard.png)

## Before you begin

You need Elasticsearch for storing and searching your data, and Kibana for visualizing and managing it.
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    To get started quickly, spin up an [Elastic Cloud Hosted](https://www.elastic.co/cloud?page=docs&placement=docs-body) deployment. Elastic Cloud Hosted is available on AWS, GCP, and Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    To install and run Elasticsearch and Kibana, see [Installing the Elastic Stack](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
  </applies-item>
</applies-switch>


## Step 1: Install Metricbeat

Install Metricbeat as close as possible to the service you want to monitor. For example, if you have four servers with MySQL running, it’s recommended that you run Metricbeat on each server. This allows Metricbeat to access your service from localhost and does not cause any additional network traffic or prevent Metricbeat from collecting metrics when there are network problems. Metrics from multiple Metricbeat instances will be combined on the Elasticsearch server.
To download and install Metricbeat, use the commands that work with your system:
<tab-set>
  <tab-item title="DEB">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/metricbeat/metricbeat-9.3.0-amd64.deb
    sudo dpkg -i metricbeat-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/metricbeat/metricbeat-9.3.0-x86_64.rpm
    sudo rpm -vi metricbeat-9.3.0-x86_64.rpm
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/metricbeat/metricbeat-9.3.0-darwin-x86_64.tar.gz
    tar xzvf metricbeat-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/metricbeat/metricbeat-9.3.0-linux-x86_64.tar.gz
    tar xzvf metricbeat-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    1. Download the [Metricbeat Windows zip file](https://artifacts.elastic.co/downloads/beats/metricbeat/metricbeat-9.3.0-windows-x86_64.zip).
    2. Extract the contents of the zip file into `C:\Program Files`.
    3. Rename the `metricbeat-[version]-windows-x86_64` directory to `Metricbeat`.
    4. Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select *Run As Administrator*).
    5. From the PowerShell prompt, run the following commands to install Metricbeat as a Windows service:

    ```shell
    PS > cd 'C:\Program Files\Metricbeat'
    PS C:\Program Files\Metricbeat> .\install-service-metricbeat.ps1
    ```

    <note>
      If script execution is disabled on your system, you need to set the execution policy for the current session to allow the script to run. For example: `PowerShell.exe -ExecutionPolicy UnRestricted -File .\install-service-metricbeat.ps1`.
    </note>

    <important applies-to="Elastic Stack: Generally available since 9.0.6">
      The base folder has changed from `C:\ProgramData\` to `C:\Program Files\`
      because the latter has stricter permissions. The home path (base for
      state and logs) is now `C:\Program Files\Metricbeat-Data`.The install script (`install-service-metricbeat.ps1`) will check whether
      `C:\ProgramData\Metricbeat` exits and move it to `C:\Program Files\Metricbeat-Data`.
      For more details on the installation script refer to: [install script](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-script).
    </important>
  </tab-item>
</tab-set>

The commands shown are for AMD platforms, but ARM packages are also available. Refer to the [download page](https://www.elastic.co/downloads/beats/metricbeat) for the full list of available packages.

### Other installation options

- [APT or YUM](https://www.elastic.co/docs/reference/beats/metricbeat/setup-repositories)
- [Download page](https://www.elastic.co/downloads/beats/metricbeat)
- [Docker](https://www.elastic.co/docs/reference/beats/metricbeat/running-on-docker)
- [Kubernetes](https://www.elastic.co/docs/reference/beats/metricbeat/running-on-kubernetes)
- [Cloud Foundry](https://www.elastic.co/docs/reference/beats/metricbeat/running-on-cloudfoundry)


## Step 2: Connect to the Elastic Stack

Connections to Elasticsearch and Kibana are required to set up Metricbeat.
Set the connection information in `metricbeat.yml`. To locate this configuration file, see [Directory layout](https://www.elastic.co/docs/reference/beats/metricbeat/directory-layout).
<applies-switch>
  <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
    Specify the [cloud.id](https://www.elastic.co/docs/reference/beats/metricbeat/configure-cloud-id) of your Elastic Cloud Hosted deployment, and set [cloud.auth](https://www.elastic.co/docs/reference/beats/metricbeat/configure-cloud-id) to a user who is authorized to set up Metricbeat. For example:
    ```yaml
    cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
    cloud.auth: "metricbeat_setup:YOUR_PASSWORD" 
    ```
  </applies-item>

  <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
    1. Set the host and port where Metricbeat can find the Elasticsearch installation, and set the username and password of a user who is authorized to set up Metricbeat. For example:
       ```yaml
       output.elasticsearch:
         hosts: ["https://myEShost:9200"]
         username: "metricbeat_internal"
         password: "YOUR_PASSWORD" 
         ssl:
           enabled: true
           ca_trusted_fingerprint: "b9a10bbe64ee9826abeda6546fc988c8bf798b41957c33d05db736716513dc9c" 
       ```
    2. If you plan to use our pre-built Kibana dashboards, configure the Kibana endpoint. Skip this step if Kibana is running on the same host as Elasticsearch.
       ```yaml
         setup.kibana:
           host: "mykibanahost:5601" 
           username: "my_kibana_user" <2> 
           password: "YOUR_PASSWORD"
       ```
  </applies-item>
</applies-switch>

To learn more about required roles and privileges, see [*Grant users access to secured resources*](https://www.elastic.co/docs/reference/beats/metricbeat/feature-roles).
<note>
  You can send data to other [outputs](https://www.elastic.co/docs/reference/beats/metricbeat/configuring-output), such as Logstash, but that requires additional configuration and setup.
</note>


## Step 3: Enable and configure metrics collection modules

Metricbeat uses modules to collect metrics. Each module defines the basic logic for collecting data from a specific service, such as Redis or MySQL. A module consists of metricsets that fetch and structure the data. Read [*How Metricbeat works*](https://www.elastic.co/docs/reference/beats/metricbeat/how-metricbeat-works) to learn more.
1. Identify the modules you need to enable. To see the list of available [modules](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-modules), run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   metricbeat modules list
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   metricbeat modules list
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./metricbeat modules list
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./metricbeat modules list
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\metricbeat.exe modules list
   ```
   </tab-item>
   </tab-set>
2. From the installation directory, enable one or more modules. If you accept the default configuration without enabling additional modules, Metricbeat collects system metrics only.
   The following command enables the nginx config in the `modules.d` directory:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   metricbeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   metricbeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./metricbeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./metricbeat modules enable nginx
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\metricbeat.exe modules enable nginx
   ```
   </tab-item>
   </tab-set>
   See the [`modules` command](/docs/reference/beats/metricbeat/command-line-options#modules-command) to learn more about this command. If you are using a Docker image, see [Run Metricbeat on Docker](https://www.elastic.co/docs/reference/beats/metricbeat/running-on-docker).
3. In the module config under `modules.d`, change the module settings to match your environment. See [Standard config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-config-options) for more about available settings.

<tip>
  To test your configuration file, change to the directory where the Metricbeat binary is installed, and run Metricbeat in the foreground with the following options specified: `./metricbeat test config -e`. Make sure your config files are in the path expected by Metricbeat (see [Directory layout](https://www.elastic.co/docs/reference/beats/metricbeat/directory-layout)), or use the `-c` flag to specify the path to the config file.
</tip>

For more information about configuring Metricbeat, also see:
- [Configure Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/configuring-howto-metricbeat)
- [Config file format](https://www.elastic.co/docs/reference/beats/libbeat/config-file-format)
- [`metricbeat.reference.yml`](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-reference-yml): This reference configuration file shows all non-deprecated options. You’ll find it in the same location as `metricbeat.yml`.


## Step 4: Set up assets

Metricbeat comes with predefined assets for parsing, indexing, and visualizing your data. To load these assets:
1. Make sure the user specified in `metricbeat.yml` is [authorized to set up Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/privileges-to-setup-beats).
2. From the installation directory, run:
   <tab-set>
   <tab-item title="DEB">
   ```sh
   metricbeat setup -e
   ```
   </tab-item>

   <tab-item title="RPM">
   ```sh
   metricbeat setup -e
   ```
   </tab-item>

   <tab-item title="MacOS">
   ```sh
   ./metricbeat setup -e
   ```
   </tab-item>

   <tab-item title="Linux">
   ```sh
   ./metricbeat setup -e
   ```
   </tab-item>

   <tab-item title="Windows">
   ```sh
   PS > .\metricbeat.exe setup -e
   ```
   </tab-item>
   </tab-set>
   `-e` is optional and sends output to standard error instead of the configured log output.

By default Windows log files are stored in `C:\Program Files\Metricbeat-Data\logs`.
<note>
  In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\metricbeat\logs`.
</note>

This step loads the recommended [index template](https://www.elastic.co/docs/manage-data/data-store/templates) for writing to Elasticsearch and deploys the sample dashboards for visualizing the data in Kibana.
<tip>
  A connection to Elasticsearch (or Elastic Cloud Hosted) is required to set up the initial environment. If you’re using a different output, such as Logstash, see [Load the index template manually](/docs/reference/beats/metricbeat/metricbeat-template#load-template-manually) and [Load Kibana dashboards](https://www.elastic.co/docs/reference/beats/metricbeat/load-kibana-dashboards).
</tip>


## Step 5: Start Metricbeat

Before starting Metricbeat, modify the user credentials in metricbeat.yml and specify a user who is [authorized to publish events](https://www.elastic.co/docs/reference/beats/metricbeat/privileges-to-publish-events).
To start Metricbeat, run:
<tab-set>
  <tab-item title="DEB">
    ```sh
    sudo service metricbeat start
    ```

    <note>
      If you use an `init.d` script to start Metricbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/metricbeat/command-line-options)). To specify flags, start Metricbeat in the foreground.
    </note>
    Also see [Metricbeat and systemd](https://www.elastic.co/docs/reference/beats/metricbeat/running-with-systemd).
  </tab-item>

  <tab-item title="RPM">
    ```sh
    sudo service metricbeat start
    ```

    <note>
      If you use an `init.d` script to start Metricbeat, you can’t specify command line flags (see [Command reference](https://www.elastic.co/docs/reference/beats/metricbeat/command-line-options)). To specify flags, start Metricbeat in the foreground.
    </note>
    Also see [Metricbeat and systemd](https://www.elastic.co/docs/reference/beats/metricbeat/running-with-systemd).
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    sudo chown root metricbeat.yml 
    sudo chown root modules.d/nginx.yml 
    sudo ./metricbeat -e
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    sudo chown root metricbeat.yml 
    sudo chown root modules.d/nginx.yml 
    sudo ./metricbeat -e
    ```
  </tab-item>

  <tab-item title="Windows">
    ```sh
    PS C:\Program Files\metricbeat> Start-Service metricbeat
    ```
    By default Windows log files are stored in `C:\Program Files\Metricbeat-Data\logs`.
    <note>
      In versions before 9.0.6, the default location for Windows log files was `C:\ProgramData\metricbeat\logs`.
    </note>

    <note>
      On Windows, statistics about system load and swap usage are currently not captured
    </note>
  </tab-item>
</tab-set>

Metricbeat should begin streaming metrics to Elasticsearch.

## Step 6: View your data in Kibana

Metricbeat comes with pre-built Kibana dashboards and UIs for visualizing log data. You loaded the dashboards earlier when you ran the `setup` command.
To open the dashboards:
1. Launch Kibana:
   <applies-switch>
   <applies-item title="ess: ga" applies-to="Elastic Cloud Hosted: Generally available">
   1. [Log in](https://cloud.elastic.co/) to your Elastic Cloud account.
   2. Navigate to the Kibana endpoint in your deployment.
   </applies-item>

   <applies-item title="self: ga" applies-to="Self-managed Elastic deployments: Generally available">
   Point your browser to [http://localhost:5601](http://localhost:5601), replacing `localhost` with the name of the Kibana host.
   </applies-item>
   </applies-switch>
2. In the side navigation, click **Discover**. To see Metricbeat data, make sure the predefined `metricbeat-*` data view is selected.
   <tip>
   If you don’t see data in Kibana, try changing the time filter to a larger range. By default, Kibana shows the last 15 minutes.
   </tip>
3. In the side navigation, click **Dashboard**, then select the dashboard that you want to open.

The dashboards are provided as examples. We recommend that you [customize](https://www.elastic.co/docs/explore-analyze/dashboards) them to meet your needs.

## What’s next?

Now that you have your infrastructure metrics streaming into Elasticsearch, learn how to unify your logs, metrics, uptime, and application performance data.
1. Ingest data from other sources by installing and configuring other Elastic Beats:
   | Elastic Beats                                                                                              | To capture                      |
   |------------------------------------------------------------------------------------------------------------|---------------------------------|
   | [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)       | Logs                            |
   | [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/winlogbeat-installation-configuration) | Windows event logs              |
   | [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/heartbeat-installation-configuration)    | Uptime information              |
   | [APM](https://www.elastic.co/docs/solutions/observability/apm)                                             | Application performance metrics |
   | [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-installation-configuration)    | Audit events                    |
2. Use the Observability apps in Kibana to search across all your data:
   | Elastic apps                                                                                                           | Use to                                                           |
   |------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------|
   | [Metrics app](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) | Explore metrics about systems and services across your ecosystem |
   | [Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs)                                      | Tail related log data in real time                               |
   | [Uptime app](https://www.elastic.co/docs/solutions/observability/synthetics#monitoring-uptime)                         | Monitor availability issues across your apps and services        |
   | [APM app](https://www.elastic.co/docs/solutions/observability/apm/overviews)                                           | Monitor application performance                                  |
   | [SIEM app](https://www.elastic.co/docs/solutions/security)                                                             | Analyze security events                                          |