﻿---
title: Event structure
description: Every event sent by Metricbeat has the same basic structure. It contains the following fields: For example: For more information about the exported fields,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-event-structure
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Event structure
Every event sent by Metricbeat has the same basic structure. It contains the following fields:
<definitions>
  <definition term="@timestamp">
    Time when the event was captured
  </definition>
  <definition term="host.hostname">
    Hostname of the server on which the Beat is running
  </definition>
  <definition term="agent.type">
    Name given to the Beat
  </definition>
  <definition term="event.module">
    Name of the module that the data is from
  </definition>
  <definition term="event.dataset">
    Name of the source dataset in the format `<module>.<metricset>`
  </definition>
</definitions>

For example:
```json
{
  "@timestamp": "2016-06-22T22:05:53.291Z",
  "agent": {
    "type": "metricbeat"
  },
  "host": {
     "hostname": "host.example.com",
   },
  "event": {
    "dataset": "system.process",
    "module": "system"
  },
  .
  .
  .

  "type": "metricsets"
}
```

For more information about the exported fields, see [Exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields).