﻿---
title: Load external configuration files
description: Metricbeat can load external configuration files for modules, which allows you to separate your configuration into multiple smaller configuration files...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-configuration-reloading
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Load external configuration files
Metricbeat can load external configuration files for modules, which allows you to separate your configuration into multiple smaller configuration files. To use this, you specify the `path` option under `metricbeat.config.modules` in the main `metricbeat.yml` configuration file. By default, Metricbeat loads the module configurations enabled in the [`modules.d`](/docs/reference/beats/metricbeat/configuration-metricbeat#configure-modules-d-configs) directory. For example:
```yaml
metricbeat.config.modules:
  path: ${path.config}/modules.d/*.yml
```

<definitions>
  <definition term="path">
    A Glob that defines the files to check for changes.
    This setting must point to the `modules.d` directory if you want to use the [`modules`](/docs/reference/beats/metricbeat/command-line-options#modules-command) command to enable and disable module configurations.
  </definition>
</definitions>

Each file found by the Glob must contain a list of one or more module definitions. For example:
```yaml
- module: system
  metricsets: ["cpu"]
  enabled: false
  period: 1s

- module: system
  metricsets: ["network"]
  enabled: true
  period: 10s
```

<note>
  On systems with POSIX file permissions, all Beats configuration files are subject to ownership and file permission checks. For more information, see [Config File Ownership and Permissions](https://www.elastic.co/docs/reference/beats/libbeat/config-file-permissions).
</note>