﻿---
title: Load Kibana dashboards
description: Metricbeat comes packaged with example Kibana dashboards, visualizations, and searches for visualizing Metricbeat data in Kibana. Before you can use the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/load-kibana-dashboards
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Load Kibana dashboards
<tip>
  For deeper observability into your infrastructure, you can use the Metrics app and the Logs app in Kibana. For more details, see [Metrics monitoring](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) and [Log monitoring](https://www.elastic.co/docs/solutions/observability/logs/explore-logs).
</tip>

Metricbeat comes packaged with example Kibana dashboards, visualizations, and searches for visualizing Metricbeat data in Kibana. Before you can use the dashboards, you need to create the index pattern, `metricbeat-*`, and load the dashboards into Kibana.
To do this, you can either run the `setup` command (as described here) or [configure dashboard loading](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-dashboards) in the `metricbeat.yml` config file. This requires a Kibana endpoint configuration. If you didn’t already configure a Kibana endpoint, see [Kibana endpoint](https://www.elastic.co/docs/reference/beats/metricbeat/setup-kibana-endpoint).

## Load dashboards

Make sure Kibana is running before you perform this step. If you are accessing a secured Kibana instance, make sure you’ve configured credentials as described in the [Quick start: installation and configuration](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration).
To load the recommended index template for writing to Elasticsearch and deploy the sample dashboards for visualizing the data in Kibana, use the command that works with your system.
<tab-set>
  <tab-item title="DEB">
    ```sh
    metricbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    metricbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./metricbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./metricbeat setup --dashboards
    ```
  </tab-item>

  <tab-item title="Docker">
    ```sh
    docker run --rm --net="host" docker.elastic.co/beats/metricbeat:9.3.0 setup --dashboards
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Metricbeat, and run:
    ```sh
    PS > .\metricbeat.exe setup --dashboards
    ```
  </tab-item>
</tab-set>

For more options, such as loading customized dashboards, see [Importing Existing Beat Dashboards](https://www.elastic.co/docs/extend/beats/import-dashboards).
If you’ve configured the Logstash output, see [Load dashboards for Logstash output](#load-dashboards-logstash).

## Load dashboards for Logstash output

During dashboard loading, Metricbeat connects to Elasticsearch to check version information. To load dashboards when the Logstash output is enabled, you need to temporarily disable the Logstash output and enable Elasticsearch. To connect to a secured Elasticsearch cluster, you also need to pass Elasticsearch credentials.
<tip>
  The example shows a hard-coded password, but you should store sensitive values in the [secrets keystore](https://www.elastic.co/docs/reference/beats/metricbeat/keystore).
</tip>

<tab-set>
  <tab-item title="DEB">
    ```sh
    metricbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=metricbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="RPM">
    ```sh
    metricbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=metricbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="MacOS">
    ```sh
    ./metricbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=metricbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Linux">
    ```sh
    ./metricbeat setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=metricbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Docker">
    ```sh
    docker run --rm --net="host" docker.elastic.co/beats/metricbeat:9.3.0 setup -e \
      -E output.logstash.enabled=false \
      -E output.elasticsearch.hosts=['localhost:9200'] \
      -E output.elasticsearch.username=metricbeat_internal \
      -E output.elasticsearch.password=YOUR_PASSWORD \
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Metricbeat, and run:
    ```sh
    PS > .\metricbeat.exe setup -e `
      -E output.logstash.enabled=false `
      -E output.elasticsearch.hosts=['localhost:9200'] `
      -E output.elasticsearch.username=metricbeat_internal `
      -E output.elasticsearch.password=YOUR_PASSWORD `
      -E setup.kibana.host=localhost:5601
    ```
  </tab-item>
</tab-set>