﻿---
title: Windows fields
description: Module for Windows perfmon service contains the status for Windows services. wmi 
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-windows
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Windows fields
Module for Windows

## windows


## perfmon

perfmon
<definitions>
  <definition term="windows.perfmon.instance">
    Instance value.
    type: keyword
  </definition>
  <definition term="windows.perfmon.metrics.*.*">
    Metric values returned.
    type: object
  </definition>
</definitions>


## service

`service` contains the status for Windows services.
<definitions>
  <definition term="windows.service.id">
    A unique ID for the service. It is a hash of the machine's GUID and the service name.
    type: keyword
    example: hW3NJFc1Ap
  </definition>
  <definition term="windows.service.name">
    The service name.
    type: keyword
    example: Wecsvc
  </definition>
  <definition term="windows.service.display_name">
    The display name of the service.
    type: keyword
    example: Windows Event Collector
  </definition>
  <definition term="windows.service.start_type">
    The startup type of the service. The possible values are `Automatic`, `Boot`, `Disabled`, `Manual`, and `System`.
    type: keyword
  </definition>
  <definition term="windows.service.start_name">
    Account name under which a service runs.
    type: keyword
    example: NT AUTHORITY\LocalService
  </definition>
  <definition term="windows.service.path_name">
    Fully qualified path to the file that implements the service, including arguments.
    type: keyword
    example: C:\WINDOWS\system32\svchost.exe -k LocalService -p
  </definition>
  <definition term="windows.service.state">
    The actual state of the service. The possible values are `Continuing`, `Pausing`, `Paused`, `Running`, `Starting`, `Stopping`, and `Stopped`.
    type: keyword
  </definition>
  <definition term="windows.service.exit_code">
    For `Stopped` services this is the error code that service reports when starting to stopping. This will be the generic Windows service error code unless the service provides a service-specific error code.
    type: keyword
  </definition>
  <definition term="windows.service.pid">
    For `Running` services this is the associated process PID.
    type: long
    example: 1092
  </definition>
  <definition term="windows.service.uptime.ms">
    The service's uptime specified in milliseconds.
    type: long
    format: duration
  </definition>
</definitions>


## wmi

<applies-to>
  - Elastic Stack: Beta since 9.1
</applies-to>

wmi