﻿---
title: vSphere fields
description: vSphere module Cluster information. datastore Datastore Cluster Host information from vSphere environment. Network-related information. Resource pool...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-vsphere
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# vSphere fields
vSphere module

## vsphere


## cluster

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Cluster information.
<definitions>
  <definition term="vsphere.cluster.datastore.names">
    List of all the datastore names associated with the cluster.
    type: keyword
  </definition>
  <definition term="vsphere.cluster.datastore.count">
    Number of datastores associated with the cluster.
    type: long
  </definition>
  <definition term="vsphere.cluster.das_config.admission.control.enabled">
    Indicates whether strict admission control is enabled.
    type: boolean
  </definition>
  <definition term="vsphere.cluster.das_config.enabled">
    Indicates whether vSphere HA feature is enabled.
    type: boolean
  </definition>
  <definition term="vsphere.cluster.host.count">
    Number of hosts associated with the cluster.
    type: long
  </definition>
  <definition term="vsphere.cluster.host.names">
    List of all the host names associated with the cluster.
    type: keyword
  </definition>
  <definition term="vsphere.cluster.id">
    Unique cluster ID.
    type: keyword
  </definition>
  <definition term="vsphere.cluster.name">
    Cluster name.
    type: keyword
  </definition>
  <definition term="vsphere.cluster.network.count">
    Number of networks associated with the cluster.
    type: long
  </definition>
  <definition term="vsphere.cluster.network.names">
    List of all the network names associated with the cluster.
    type: keyword
  </definition>
  <definition term="vsphere.cluster.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
  <definition term="vsphere.cluster.resourcepool.id Elastic Stack: Generally available since 9.1">
    ID of resource pool associated with the cluster.
    type: keyword
  </definition>
</definitions>


## datastore

datastore
<definitions>
  <definition term="vsphere.datastore.capacity.free.bytes">
    Free bytes of the datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.capacity.total.bytes">
    Total bytes of the datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.capacity.used.bytes">
    Used bytes of the datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.capacity.used.pct">
    Percentage of datastore capacity used.
    type: scaled_float
    format: percent
  </definition>
  <definition term="vsphere.datastore.disk.capacity.bytes">
    Configured size of the datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.disk.capacity.usage.bytes">
    The amount of storage capacity currently being consumed by datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.disk.provisioned.bytes">
    Amount of storage set aside for use by a datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.fstype">
    Filesystem type.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.host.count">
    Number of hosts.
    type: long
  </definition>
  <definition term="vsphere.datastore.host.names">
    List of all the host names.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.id">
    Unique datastore ID.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.name">
    Datastore name.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.read.bytes">
    Rate of reading data from the datastore.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastore.status">
    Status of the datastore.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
  <definition term="vsphere.datastore.vm.count">
    Number of VMs.
    type: long
  </definition>
  <definition term="vsphere.datastore.vm.names">
    List of all the VM names.
    type: keyword
  </definition>
  <definition term="vsphere.datastore.write.bytes">
    Rate of writing data to the datastore.
    type: long
    format: bytes
  </definition>
</definitions>


## datastorecluster

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Datastore Cluster
<definitions>
  <definition term="vsphere.datastorecluster.id">
    Unique datastore cluster ID.
    type: keyword
  </definition>
  <definition term="vsphere.datastorecluster.name">
    The datastore cluster name.
    type: keyword
  </definition>
  <definition term="vsphere.datastorecluster.capacity.bytes">
    Total capacity of this storage pod, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastorecluster.free_space.bytes">
    Total free space on this storage pod, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.datastorecluster.datastore.names">
    List of all the datastore names associated with the datastore cluster.
    type: keyword
  </definition>
  <definition term="vsphere.datastorecluster.datastore.count">
    Number of datastores in the datastore cluster.
    type: long
  </definition>
  <definition term="vsphere.datastorecluster.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
</definitions>


## host

Host information from vSphere environment.
<definitions>
  <definition term="vsphere.host.cpu.used.mhz">
    Used CPU in MHz.
    type: long
  </definition>
  <definition term="vsphere.host.cpu.total.mhz">
    Total CPU in MHz.
    type: long
  </definition>
  <definition term="vsphere.host.cpu.free.mhz">
    Free CPU in MHz.
    type: long
  </definition>
  <definition term="vsphere.host.datastore.names">
    List of all the datastore names.
    type: keyword
  </definition>
  <definition term="vsphere.host.datastore.count">
    Number of datastores on the host.
    type: long
  </definition>
  <definition term="vsphere.host.disk.capacity.usage.bytes">
    The amount of storage capacity currently being consumed by or on the entity.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.disk.devicelatency.average.ms">
    Average amount of time it takes to complete an SCSI command from physical device in milliseconds.
    type: long
  </definition>
  <definition term="vsphere.host.disk.latency.total.ms">
    Highest latency value across all disks used by the host in milliseconds.
    type: long
  </definition>
  <definition term="vsphere.host.disk.read.bytes">
    Average number of bytes read from the disk each second.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.disk.write.bytes">
    Average number of bytes written to the disk each second.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.disk.total.bytes">
    Sum of disk read and write rates each second in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.id">
    Unique host ID.
    type: keyword
  </definition>
  <definition term="vsphere.host.memory.free.bytes">
    Free Memory in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.memory.total.bytes">
    Total Memory in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.memory.used.bytes">
    Used Memory in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.name">
    Host name.
    type: keyword
  </definition>
  <definition term="vsphere.host.network_names">
    Network names.
    type: keyword
  </definition>
  <definition term="vsphere.host.network.names">
    List of all the network names.
    type: keyword
  </definition>
  <definition term="vsphere.host.network.count">
    Number of networks on the host.
    type: long
  </definition>
  <definition term="vsphere.host.network.bandwidth.transmitted.bytes">
    Average rate at which data was transmitted during the interval. This represents the bandwidth of the network.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.network.bandwidth.received.bytes">
    Average rate at which data was received during the interval. This represents the bandwidth of the network.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.network.bandwidth.total.bytes">
    Sum of network transmitted and received rates in bytes during the interval.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.host.network.packets.transmitted.count">
    Number of packets transmitted.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.received.count">
    Number of packets received.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.errors.transmitted.count">
    Number of packets with errors transmitted.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.errors.received.count">
    Number of packets with errors received.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.errors.total.count">
    Total number of packets with errors.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.multicast.transmitted.count">
    Number of multicast packets transmitted.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.multicast.received.count">
    Number of multicast packets received.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.multicast.total.count">
    Total number of multicast packets.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.dropped.transmitted.count">
    Number of transmitted packets dropped.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.dropped.received.count">
    Number of received packets dropped.
    type: long
  </definition>
  <definition term="vsphere.host.network.packets.dropped.total.count">
    Total number of packets dropped.
    type: long
  </definition>
  <definition term="vsphere.host.status">
    The overall health status of a host in the vSphere environment.
    type: keyword
  </definition>
  <definition term="vsphere.host.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
  <definition term="vsphere.host.uptime">
    The total uptime of a host in seconds within the vSphere environment.
    type: long
  </definition>
  <definition term="vsphere.host.vm.names">
    List of all the VM names.
    type: keyword
  </definition>
  <definition term="vsphere.host.vm.count">
    Number of virtual machines on the host.
    type: long
  </definition>
</definitions>


## network

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Network-related information.
<definitions>
  <definition term="vsphere.network.accessible">
    Indicates whether at least one host is configured to provide this network.
    type: boolean
  </definition>
  <definition term="vsphere.network.config.status">
    Indicates whether the system has detected a configuration issue.
    type: keyword
  </definition>
  <definition term="vsphere.network.host.names">
    Names of the hosts connected to this network.
    type: keyword
  </definition>
  <definition term="vsphere.network.host.count">
    Number of hosts connected to this network.
    type: long
  </definition>
  <definition term="vsphere.network.id">
    Unique network ID.
    type: keyword
  </definition>
  <definition term="vsphere.network.name">
    Name of the network.
    type: keyword
  </definition>
  <definition term="vsphere.network.status">
    General health of the network.
    type: keyword
  </definition>
  <definition term="vsphere.network.type">
    Type of the network (e.g., Network(Standard), DistributedVirtualport).
    type: keyword
  </definition>
  <definition term="vsphere.network.vm.names">
    Names of the virtual machines connected to this network.
    type: keyword
  </definition>
  <definition term="vsphere.network.vm.count">
    Number of virtual machines connected to this network.
    type: long
  </definition>
  <definition term="vsphere.network.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
</definitions>


## resourcepool

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Resource pool information from vSphere environment.
<definitions>
  <definition term="vsphere.resourcepool.cpu.usage.mhz">
    Basic CPU performance statistics, in MHz.
    type: long
  </definition>
  <definition term="vsphere.resourcepool.cpu.demand.mhz">
    Basic CPU performance statistics, in MHz.
    type: long
  </definition>
  <definition term="vsphere.resourcepool.cpu.entitlement.mhz">
    The amount of CPU resource, in MHz, that this VM is entitled to, as calculated by DRS.
    type: long
  </definition>
  <definition term="vsphere.resourcepool.cpu.entitlement.static.mhz">
    The static CPU resource entitlement for a virtual machine.
    type: long
  </definition>
  <definition term="vsphere.resourcepool.id">
    Unique resource pool ID.
    type: keyword
  </definition>
  <definition term="vsphere.resourcepool.memory.usage.guest.bytes">
    Guest memory utilization statistics, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.usage.host.bytes">
    Host memory utilization statistics, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.entitlement.bytes">
    The amount of memory, in bytes, that this VM is entitled to, as calculated by DRS.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.entitlement.static.bytes">
    The static memory resource entitlement for a virtual machine, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.private.bytes">
    The portion of memory, in bytes, that is granted to a virtual machine from non-shared host memory.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.shared.bytes">
    The portion of memory, in bytes, that is granted to a virtual machine from host memory that is shared between VMs.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.swapped.bytes">
    The portion of memory, in bytes, that is granted to a virtual machine from the host's swap space.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.ballooned.bytes">
    The size of the balloon driver in a virtual machine, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.overhead.bytes">
    The amount of memory resource (in bytes) that will be used by a virtual machine above its guest memory requirements.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.overhead.consumed.bytes">
    The amount of overhead memory, in bytes, currently being consumed to run a VM.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.memory.compressed.bytes">
    The amount of compressed memory currently consumed by VM, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.resourcepool.name">
    The name of the resource pool.
    type: keyword
  </definition>
  <definition term="vsphere.resourcepool.status">
    The overall health status of a host in the vSphere environment.
    type: keyword
  </definition>
  <definition term="vsphere.resourcepool.vm.count">
    Number of virtual machines on the resource pool.
    type: long
  </definition>
  <definition term="vsphere.resourcepool.vm.names">
    Names of virtual machines on the resource pool.
    type: keyword
  </definition>
  <definition term="vsphere.resourcepool.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
</definitions>


## virtualmachine

virtualmachine
<definitions>
  <definition term="vsphere.virtualmachine.host.id">
    Host id.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.host.hostname">
    Hostname of the host.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.id">
    Unique virtual machine ID.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.name">
    Virtual machine name.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.os">
    Virtual machine Operating System name.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.cpu.used.mhz">
    Used CPU in Mhz.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.cpu.total.mhz">
    Total Reserved CPU in Mhz.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.cpu.free.mhz">
    Available CPU in Mhz.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.cpu.usage.percent">
    CPU usage as a percentage.
    type: scaled_float
  </definition>
  <definition term="vsphere.virtualmachine.memory.used.guest.bytes">
    Used memory of Guest in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.virtualmachine.memory.used.host.bytes">
    Used memory of Host in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.virtualmachine.memory.total.guest.bytes">
    Total memory of Guest in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.virtualmachine.memory.free.guest.bytes">
    Free memory of Guest in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="vsphere.virtualmachine.memory.usage.percent">
    Memory usage as percent of total configured or available memory.
    type: scaled_float
  </definition>
  <definition term="vsphere.virtualmachine.custom_fields">
    Custom fields.
    type: object
  </definition>
  <definition term="vsphere.virtualmachine.network_names">
    Network names.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.datastore.names">
    Names of the datastore associated to this virtualmachine.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.datastore.count">
    Number of datastores associated to this virtualmachine.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.network.names">
    Names of the networks associated to this virtualmachine.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.network.count">
    Number of networks associated to this virtualmachine.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.status">
    Overall health and status of a virtual machine.
    type: keyword
  </definition>
  <definition term="vsphere.virtualmachine.uptime">
    The uptime of the VM in seconds.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.snapshot.info.*">
    Details of the snapshots of this virtualmachine.
    type: object
  </definition>
  <definition term="vsphere.virtualmachine.snapshot.count">
    The number of snapshots of this virtualmachine.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.triggered_alarms.*">
    List of all the triggered alarms.
    type: object
  </definition>
  <definition term="vsphere.virtualmachine.disk.average.bytes">
    Aggregated disk I/O rate.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.disk.read.average.bytes">
    Rate at which data is read from each virtual disk on the virtual machine.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.disk.write.average.bytes">
    Rate at which data is written to each virtual disk on the virtual machine.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.disk.numberRead.count">
    Number of times data was read.
    type: long
  </definition>
  <definition term="vsphere.virtualmachine.disk.numberWrite.count">
    Number of disk writes.
    type: long
  </definition>
</definitions>