﻿---
title: uWSGI fields
description: uwsgi module uwsgi.status metricset fields 
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-uwsgi
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# uWSGI fields
uwsgi module

## uwsgi


## status

uwsgi.status metricset fields
<definitions>
  <definition term="uwsgi.status.total.requests">
    Total requests handled
    type: long
  </definition>
  <definition term="uwsgi.status.total.exceptions">
    Total exceptions
    type: long
  </definition>
  <definition term="uwsgi.status.total.write_errors">
    Total requests write errors
    type: long
  </definition>
  <definition term="uwsgi.status.total.read_errors">
    Total read errors
    type: long
  </definition>
  <definition term="uwsgi.status.total.pid">
    Process id
    type: long
  </definition>
  <definition term="uwsgi.status.worker.id">
    Worker id
    type: long
  </definition>
  <definition term="uwsgi.status.worker.pid">
    Worker process id
    type: long
  </definition>
  <definition term="uwsgi.status.worker.accepting">
    State of worker, 1 if still accepting new requests otherwise 0
    type: long
  </definition>
  <definition term="uwsgi.status.worker.requests">
    Number of requests served by this worker
    type: long
  </definition>
  <definition term="uwsgi.status.worker.delta_requests">
    Number of requests served by this worker after worker is reloaded when reached MAX_REQUESTS
    type: long
  </definition>
  <definition term="uwsgi.status.worker.exceptions">
    Exceptions raised
    type: long
  </definition>
  <definition term="uwsgi.status.worker.harakiri_count">
    Dropped requests by timeout
    type: long
  </definition>
  <definition term="uwsgi.status.worker.signals">
    Emitted signals count
    type: long
  </definition>
  <definition term="uwsgi.status.worker.signal_queue">
    Number of signals waiting to be handled
    type: long
  </definition>
  <definition term="uwsgi.status.worker.status">
    Worker status (cheap, pause, sig, busy, idle)
    type: keyword
  </definition>
  <definition term="uwsgi.status.worker.rss">
    Resident Set Size. memory currently used by a process. if always zero try `--memory-report` option of uwsgi
    type: long
  </definition>
  <definition term="uwsgi.status.worker.vsz">
    Virtual Set Size. memory size assigned to a process. if always zero try `--memory-report` option of uwsgi
    type: long
  </definition>
  <definition term="uwsgi.status.worker.running_time">
    Process running time
    type: long
  </definition>
  <definition term="uwsgi.status.worker.respawn_count">
    Respawn count
    type: long
  </definition>
  <definition term="uwsgi.status.worker.tx">
    Transmitted size
    type: long
  </definition>
  <definition term="uwsgi.status.worker.avg_rt">
    Average response time
    type: long
  </definition>
  <definition term="uwsgi.status.core.id">
    worker ID
    type: long
  </definition>
  <definition term="uwsgi.status.core.worker_pid">
    Parent worker PID
    type: long
  </definition>
  <definition term="uwsgi.status.core.requests.total">
    Number of total requests served
    type: long
  </definition>
  <definition term="uwsgi.status.core.requests.static">
    Number of static file serves
    type: long
  </definition>
  <definition term="uwsgi.status.core.requests.routed">
    Routed requests
    type: long
  </definition>
  <definition term="uwsgi.status.core.requests.offloaded">
    Offloaded requests
    type: long
  </definition>
  <definition term="uwsgi.status.core.write_errors">
    Number of failed writes
    type: long
  </definition>
  <definition term="uwsgi.status.core.read_errors">
    Number of failed reads
    type: long
  </definition>
</definitions>