﻿---
title: Tomcat fields
description: Tomcat module Catalina Cache metrics from the WebResourceRoot Memory metrics from java.lang JMX Requests processor metrics from GlobalRequestProcessor...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-tomcat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Tomcat fields
Tomcat module

## cache

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Catalina Cache metrics from the WebResourceRoot
<definitions>
  <definition term="tomcat.cache.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="tomcat.cache.hit.total">
    The number of requests for resources that were served from the cache
    type: long
  </definition>
  <definition term="tomcat.cache.size.total.kb">
    The current estimate of the cache size in kilobytes
    type: long
  </definition>
  <definition term="tomcat.cache.size.max.kb">
    The maximum permitted size of the cache in kilobytes
    type: long
  </definition>
  <definition term="tomcat.cache.lookup.total">
    The number of requests for resources
    type: long
  </definition>
  <definition term="tomcat.cache.ttl.ms">
    The time-to-live for cache entries in milliseconds
    type: long
  </definition>
</definitions>


## memory

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Memory metrics from java.lang JMX
<definitions>
  <definition term="tomcat.memory.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="tomcat.memory.heap.usage.committed">
    Committed heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.heap.usage.max">
    Max heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.heap.usage.used">
    Used heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.heap.usage.init">
    Initial heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.other.usage.committed">
    Committed non-heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.other.usage.max">
    Max non-heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.other.usage.used">
    Used non-heap memory usage
    type: long
  </definition>
  <definition term="tomcat.memory.other.usage.init">
    Initial non-heap memory usage
    type: long
  </definition>
</definitions>


## requests

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Requests processor metrics from GlobalRequestProcessor JMX
<definitions>
  <definition term="tomcat.requests.mbean">
    Mbean that this event is related to
    type: keyword
  </definition>
  <definition term="tomcat.requests.total">
    Number of requests processed
    type: long
  </definition>
  <definition term="tomcat.requests.bytes.received">
    Amount of data received, in bytes
    type: long
  </definition>
  <definition term="tomcat.requests.bytes.sent">
    Amount of data sent, in bytes
    type: long
  </definition>
  <definition term="tomcat.requests.processing.ms">
    Total time to process the requests
    type: long
  </definition>
  <definition term="tomcat.requests.errors.total">
    Number of errors
    type: long
  </definition>
</definitions>


## threading

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Threading metrics from the Catalina's ThreadPool JMX
<definitions>
  <definition term="tomcat.threading.busy">
    Current busy threads from the ThreadPool
    type: long
  </definition>
  <definition term="tomcat.threading.max">
    Max threads from the ThreadPool
    type: long
  </definition>
  <definition term="tomcat.threading.current">
    Current number of threads, taken from the ThreadPool
    type: long
  </definition>
  <definition term="tomcat.threading.keep_alive.total">
    Total keep alive on the ThreadPool
    type: long
  </definition>
  <definition term="tomcat.threading.keep_alive.timeout.ms">
    Keep alive timeout on the ThreadPool
    type: long
  </definition>
  <definition term="tomcat.threading.started.total">
    Current started threads at JVM level (from java.lang:type=Threading)
    type: long
  </definition>
  <definition term="tomcat.threading.user.time.ms">
    User time in milliseconds (from java.lang:type=Threading)
    type: long
  </definition>
  <definition term="tomcat.threading.cpu.time.ms">
    CPU time in milliseconds (from java.lang:type=Threading)
    type: long
  </definition>
  <definition term="tomcat.threading.total">
    Total threads at the JVM level (from java.lang:type=Threading)
    type: long
  </definition>
  <definition term="tomcat.threading.peak">
    Peak number of threads at JVM level (from java.lang:type=Threading)
    type: long
  </definition>
</definitions>