﻿---
title: System fields
description: System status metrics, like CPU and memory usage, that are collected from the operating system. Process metrics. system contains local system metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System fields
System status metrics, like CPU and memory usage, that are collected from the operating system.

## process

Process metrics.
<definitions>
  <definition term="process.state">
    The process state. For example: "running".
    type: keyword
  </definition>
  <definition term="process.cpu.pct">
    The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 1.
    type: scaled_float
    format: percent
  </definition>
  <definition term="process.cpu.start_time">
    The time when the process was started.
    type: date
  </definition>
  <definition term="process.memory.pct">
    The percentage of memory the process occupied in main memory (RAM).
    type: scaled_float
    format: percent
  </definition>
</definitions>


## system

`system` contains local system metrics.

## core

`system-core` contains CPU metrics for a single core of a multi-core system.
<definitions>
  <definition term="system.core.id">
    CPU Core number.
    type: long
  </definition>
  <definition term="system.core.total.pct">
    Total active time spent by the core
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.user.pct">
    The percentage of CPU time spent in user space.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.user.ticks">
    The amount of CPU time spent in user space.
    type: long
  </definition>
  <definition term="system.core.system.pct">
    The percentage of CPU time spent in kernel space.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.system.ticks">
    The amount of CPU time spent in kernel space.
    type: long
  </definition>
  <definition term="system.core.nice.pct">
    The percentage of CPU time spent on low-priority processes.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.nice.ticks">
    The amount of CPU time spent on low-priority processes.
    type: long
  </definition>
  <definition term="system.core.idle.pct">
    The percentage of CPU time spent idle.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.idle.ticks">
    The amount of CPU time spent idle.
    type: long
  </definition>
  <definition term="system.core.iowait.pct">
    The percentage of CPU time spent in wait (on disk).
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.iowait.ticks">
    The amount of CPU time spent in wait (on disk).
    type: long
  </definition>
  <definition term="system.core.irq.pct">
    The percentage of CPU time spent servicing and handling hardware interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.irq.ticks">
    The amount of CPU time spent servicing and handling hardware interrupts.
    type: long
  </definition>
  <definition term="system.core.softirq.pct">
    The percentage of CPU time spent servicing and handling software interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.softirq.ticks">
    The amount of CPU time spent servicing and handling software interrupts.
    type: long
  </definition>
  <definition term="system.core.steal.pct">
    The percentage of CPU time spent in involuntary wait by the virtual CPU while the hypervisor was servicing another processor. Available only on Unix.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.core.steal.ticks">
    The amount of CPU time spent in involuntary wait by the virtual CPU while the hypervisor was servicing another processor. Available only on Unix.
    type: long
  </definition>
  <definition term="system.core.model_number">
    CPU model number. Only availabe on Linux
    type: keyword
  </definition>
  <definition term="system.core.model_name">
    CPU model name. Only availabe on Linux
    type: keyword
  </definition>
  <definition term="system.core.mhz">
    CPU core current clock. Only availabe on Linux
    type: float
  </definition>
  <definition term="system.core.core_id">
    CPU physical core ID. One core might might execute multiple threads, hence more than one `system.core.id` can share the same `system.core.core_id`. Only availabe on Linux
    type: keyword
  </definition>
  <definition term="system.core.physical_id">
    CPU core physical ID. Only availabe on Linux
    type: keyword
  </definition>
</definitions>


## cpu

`cpu` contains local CPU stats.
<definitions>
  <definition term="system.cpu.cores">
    The number of CPU cores present on the host. The non-normalized percentages will have a maximum value of `100% * cores`. The normalized percentages already take this value into account and have a maximum value of 100%.
    type: long
  </definition>
  <definition term="system.cpu.user.pct">
    The percentage of CPU time spent in user space. On multi-core systems, you can have percentages that are greater than 100%. For example, if 3 cores are at 60% use, then the `system.cpu.user.pct` will be 180%.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.system.pct">
    The percentage of CPU time spent in kernel space.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.nice.pct">
    The percentage of CPU time spent on low-priority processes.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.idle.pct">
    The percentage of CPU time spent idle.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.iowait.pct">
    The percentage of CPU time spent in wait (on disk).
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.irq.pct">
    The percentage of CPU time spent servicing and handling hardware interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.softirq.pct">
    The percentage of CPU time spent servicing and handling software interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.steal.pct">
    The percentage of CPU time spent in involuntary wait by the virtual CPU while the hypervisor was servicing another processor. Available only on Unix.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.total.pct">
    The percentage of CPU time spent in states other than Idle and IOWait.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.user.norm.pct">
    The percentage of CPU time spent in user space.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.system.norm.pct">
    The percentage of CPU time spent in kernel space.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.nice.norm.pct">
    The percentage of CPU time spent on low-priority processes.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.idle.norm.pct">
    The percentage of CPU time spent idle.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.iowait.norm.pct">
    The percentage of CPU time spent in wait (on disk).
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.irq.norm.pct">
    The percentage of CPU time spent servicing and handling hardware interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.softirq.norm.pct">
    The percentage of CPU time spent servicing and handling software interrupts.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.steal.norm.pct">
    The percentage of CPU time spent in involuntary wait by the virtual CPU while the hypervisor was servicing another processor. Available only on Unix.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.total.norm.pct">
    The percentage of CPU time in states other than Idle and IOWait, normalised by the number of cores.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.cpu.user.ticks">
    The amount of CPU time spent in user space.
    type: long
  </definition>
  <definition term="system.cpu.system.ticks">
    The amount of CPU time spent in kernel space.
    type: long
  </definition>
  <definition term="system.cpu.nice.ticks">
    The amount of CPU time spent on low-priority processes.
    type: long
  </definition>
  <definition term="system.cpu.idle.ticks">
    The amount of CPU time spent idle.
    type: long
  </definition>
  <definition term="system.cpu.iowait.ticks">
    The amount of CPU time spent in wait (on disk).
    type: long
  </definition>
  <definition term="system.cpu.irq.ticks">
    The amount of CPU time spent servicing and handling hardware interrupts.
    type: long
  </definition>
  <definition term="system.cpu.softirq.ticks">
    The amount of CPU time spent servicing and handling software interrupts.
    type: long
  </definition>
  <definition term="system.cpu.steal.ticks">
    The amount of CPU time spent in involuntary wait by the virtual CPU while the hypervisor was servicing another processor. Available only on Unix.
    type: long
  </definition>
</definitions>


## diskio

`disk` contains disk IO metrics collected from the operating system.
<definitions>
  <definition term="system.diskio.name">
    The disk name.
    type: keyword
    example: sda1
  </definition>
  <definition term="system.diskio.serial_number">
    The disk's serial number. This may not be provided by all operating systems.
    type: keyword
  </definition>
  <definition term="system.diskio.read.count">
    The total number of reads completed successfully.
    type: long
  </definition>
  <definition term="system.diskio.write.count">
    The total number of writes completed successfully.
    type: long
  </definition>
  <definition term="system.diskio.read.bytes">
    The total number of bytes read successfully. On Linux this is the number of sectors read multiplied by an assumed sector size of 512.
    type: long
    format: bytes
  </definition>
  <definition term="system.diskio.write.bytes">
    The total number of bytes written successfully. On Linux this is the number of sectors written multiplied by an assumed sector size of 512.
    type: long
    format: bytes
  </definition>
  <definition term="system.diskio.read.time">
    The total number of milliseconds spent by all reads.
    type: long
  </definition>
  <definition term="system.diskio.write.time">
    The total number of milliseconds spent by all writes.
    type: long
  </definition>
  <definition term="system.diskio.io.time">
    The total number of of milliseconds spent doing I/Os.
    type: long
  </definition>
  <definition term="system.diskio.io.ops">
    The total number of I/Os in progress.
    type: long
  </definition>
</definitions>


## entropy

Available system entropy
<definitions>
  <definition term="system.entropy.available_bits">
    The available bits of entropy
    type: long
  </definition>
  <definition term="system.entropy.pct">
    The percentage of available entropy, relative to the pool size of 4096
    type: scaled_float
    format: percent
  </definition>
</definitions>


## filesystem

`filesystem` contains local filesystem stats.
<definitions>
  <definition term="system.filesystem.available">
    The disk space available to an unprivileged user in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.filesystem.device_name">
    The disk name. For example: `/dev/disk1`
    type: keyword
  </definition>
  <definition term="system.filesystem.type">
    The disk type. For example: `ext4`. In some case for Windows OS the value will be `unavailable` as access to this information is not allowed (ex. external disks).
    type: keyword
  </definition>
  <definition term="system.filesystem.mount_point">
    The mounting point. For example: `/`
    type: keyword
  </definition>
  <definition term="system.filesystem.files">
    Total number of inodes on the system, which will be a combination of files, folders, symlinks, and devices.
    type: long
  </definition>
  <definition term="system.filesystem.options">
    The options present on the filesystem mount.
    type: keyword
  </definition>
  <definition term="system.filesystem.free">
    The disk space available in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.filesystem.free_files">
    The number of free inodes in the file system.
    type: long
  </definition>
  <definition term="system.filesystem.total">
    The total disk space in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.filesystem.used.bytes">
    The used disk space in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.filesystem.used.pct">
    The percentage of used disk space.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## fsstat

`system.fsstat` contains filesystem metrics aggregated from all mounted filesystems.
<definitions>
  <definition term="system.fsstat.count">
    Number of file systems found.
    type: long
  </definition>
  <definition term="system.fsstat.total_files">
    Total number of inodes on the system, which will be a combination of files, folders, symlinks, and devices. Not on Windows.
    type: long
  </definition>
</definitions>


## total_size

Nested file system docs.
<definitions>
  <definition term="system.fsstat.total_size.free">
    Total free space.
    type: long
    format: bytes
  </definition>
  <definition term="system.fsstat.total_size.used">
    Total used space.
    type: long
    format: bytes
  </definition>
  <definition term="system.fsstat.total_size.total">
    Total space (used plus free).
    type: long
    format: bytes
  </definition>
</definitions>


## load

CPU load averages.
<definitions>
  <definition term="system.load.1">
    Load average for the last minute.
    type: scaled_float
  </definition>
  <definition term="system.load.5">
    Load average for the last 5 minutes.
    type: scaled_float
  </definition>
  <definition term="system.load.15">
    Load average for the last 15 minutes.
    type: scaled_float
  </definition>
  <definition term="system.load.norm.1">
    Load for the last minute divided by the number of cores.
    type: scaled_float
  </definition>
  <definition term="system.load.norm.5">
    Load for the last 5 minutes divided by the number of cores.
    type: scaled_float
  </definition>
  <definition term="system.load.norm.15">
    Load for the last 15 minutes divided by the number of cores.
    type: scaled_float
  </definition>
  <definition term="system.load.cores">
    The number of CPU cores present on the host.
    type: long
  </definition>
</definitions>


## memory

`memory` contains local memory stats.
<definitions>
  <definition term="system.memory.total">
    Total memory.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.used.bytes">
    Used memory.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.free">
    The total amount of free memory in bytes. This value does not include memory consumed by system caches and buffers (see system.memory.actual.free).
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.cached">
    Total Cached memory on system.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.used.pct">
    The percentage of used memory.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## actual

Actual memory used and free.
<definitions>
  <definition term="system.memory.actual.used.bytes">
    Actual used memory in bytes. It represents the difference between the total and the available memory. The available memory depends on the OS. For more details, please check `system.actual.free`.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.actual.free">
    Actual free memory in bytes. It is calculated based on the OS. On Linux this value will be MemAvailable from /proc/meminfo,  or calculated from free memory plus caches and buffers if /proc/meminfo is not available. On OSX it is a sum of free memory and the inactive memory. On Windows, it is equal to `system.memory.free`.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.actual.used.pct">
    The percentage of actual used memory.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## swap

This group contains statistics related to the swap memory usage on the system.
<definitions>
  <definition term="system.memory.swap.total">
    Total swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.swap.used.bytes">
    Used swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.swap.free">
    Available swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="system.memory.swap.used.pct">
    The percentage of used swap memory.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## network

`network` contains network IO metrics for a single network interface.
<definitions>
  <definition term="system.network.name">
    The network interface name.
    type: keyword
    example: eth0
  </definition>
  <definition term="system.network.out.bytes">
    The number of bytes sent.
    type: long
    format: bytes
  </definition>
  <definition term="system.network.in.bytes">
    The number of bytes received.
    type: long
    format: bytes
  </definition>
  <definition term="system.network.out.packets">
    The number of packets sent.
    type: long
  </definition>
  <definition term="system.network.in.packets">
    The number or packets received.
    type: long
  </definition>
  <definition term="system.network.in.errors">
    The number of errors while receiving.
    type: long
  </definition>
  <definition term="system.network.out.errors">
    The number of errors while sending.
    type: long
  </definition>
  <definition term="system.network.in.dropped">
    The number of incoming packets that were dropped.
    type: long
  </definition>
  <definition term="system.network.out.dropped">
    The number of outgoing packets that were dropped. This value is always 0 on Darwin and BSD because it is not reported by the operating system.
    type: long
  </definition>
</definitions>


## network_summary

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Metrics relating to global network activity
<definitions>
  <definition term="system.network_summary.ip.*">
    IP counters
    type: object
  </definition>
  <definition term="system.network_summary.tcp.*">
    TCP counters
    type: object
  </definition>
  <definition term="system.network_summary.udp.*">
    UDP counters
    type: object
  </definition>
  <definition term="system.network_summary.udp_lite.*">
    UDP Lite counters
    type: object
  </definition>
  <definition term="system.network_summary.icmp.*">
    ICMP counters
    type: object
  </definition>
</definitions>


## ntp

<applies-to>
  - Elastic Stack: Beta since 9.2
</applies-to>

`ntp` contains Network Time Protocol (NTP) metrics.
<definitions>
  <definition term="system.ntp.host">
    The remote NTP server address.
    type: keyword
  </definition>
  <definition term="system.ntp.offset">
    The estimated offset of the local host's system clock relative to the server's clock (in ns).
    type: long
  </definition>
</definitions>


## process

`process` contains process metadata, CPU metrics, and memory metrics.
<definitions>
  <definition term="system.process.name">
    type: alias
    alias to: process.name
  </definition>
  <definition term="system.process.state">
    The process state. For example: "running".
    type: keyword
  </definition>
  <definition term="system.process.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="system.process.ppid">
    type: alias
    alias to: process.parent.pid
  </definition>
  <definition term="system.process.pgid">
    type: alias
    alias to: process.pgid
  </definition>
  <definition term="system.process.num_threads">
    Number of threads in the process
    type: integer
  </definition>
  <definition term="system.process.cmdline">
    The full command-line used to start the process, including the arguments separated by space.
    type: keyword
  </definition>
  <definition term="system.process.username">
    type: alias
    alias to: user.name
  </definition>
  <definition term="system.process.cwd">
    type: alias
    alias to: process.working_directory
  </definition>
  <definition term="system.process.env">
    The environment variables used to start the process. The data is available on FreeBSD, Linux, and OS X.
    type: object
  </definition>
</definitions>


## cpu

CPU-specific statistics per process.
<definitions>
  <definition term="system.process.cpu.user.ticks">
    The amount of CPU time the process spent in user space.
    type: long
  </definition>
  <definition term="system.process.cpu.total.value">
    The value of CPU usage since starting the process.
    type: long
  </definition>
  <definition term="system.process.cpu.total.pct">
    The percentage of CPU time spent by the process since the last update. Its value is similar to the %CPU value of the process displayed by the top command on Unix systems.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.process.cpu.total.norm.pct">
    The percentage of CPU time spent by the process since the last event. This value is normalized by the number of CPU cores and it ranges from 0 to 100%.
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.process.cpu.system.ticks">
    The amount of CPU time the process spent in kernel space.
    type: long
  </definition>
  <definition term="system.process.cpu.total.ticks">
    The total CPU time spent by the process.
    type: long
  </definition>
  <definition term="system.process.cpu.start_time">
    The time when the process was started.
    type: date
  </definition>
</definitions>


## memory

Memory-specific statistics per process.
<definitions>
  <definition term="system.process.memory.size">
    The total virtual memory the process has. On Windows this represents the Commit Charge (the total amount of memory that the memory manager has committed for a running process) value in bytes for this process.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.memory.rss.bytes">
    The Resident Set Size. The amount of memory the process occupied in main memory (RAM). On Windows this represents the current working set size, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.memory.rss.pct">
    The percentage of memory the process occupied in main memory (RAM).
    type: scaled_float
    format: percent
  </definition>
  <definition term="system.process.memory.share">
    The shared memory the process uses.
    type: long
    format: bytes
  </definition>
</definitions>


## io

Disk I/O Metrics, as forwarded from /proc/[PID]/io. Available on Linux only.
<definitions>
  <definition term="system.process.io.cancelled_write_bytes">
    The number of bytes this process cancelled, or caused not to be written.
    type: long
  </definition>
  <definition term="system.process.io.read_bytes">
    The number of bytes fetched from the storage layer.
    type: long
  </definition>
  <definition term="system.process.io.write_bytes">
    The number of bytes written to the storage layer.
    type: long
  </definition>
  <definition term="system.process.io.read_char">
    The number of bytes read from read(2) and similar syscalls.
    type: long
  </definition>
  <definition term="system.process.io.write_char">
    The number of bytes sent to syscalls for writing.
    type: long
  </definition>
  <definition term="system.process.io.read_ops">
    The count of read-related syscalls.
    type: long
  </definition>
  <definition term="system.process.io.write_ops">
    The count of write-related syscalls.
    type: long
  </definition>
</definitions>


## fd

File descriptor usage metrics. This set of metrics is available for Linux and FreeBSD.
<definitions>
  <definition term="system.process.fd.open">
    The number of file descriptors open by the process.
    type: long
  </definition>
  <definition term="system.process.fd.limit.soft">
    The soft limit on the number of file descriptors opened by the process. The soft limit can be changed by the process at any time.
    type: long
  </definition>
  <definition term="system.process.fd.limit.hard">
    The hard limit on the number of file descriptors opened by the process. The hard limit can only be raised by root.
    type: long
  </definition>
</definitions>


## cgroup

Metrics and limits from the cgroup of which the task is a member. cgroup metrics are reported when the process has membership in a non-root cgroup. These metrics are only available on Linux.
<definitions>
  <definition term="system.process.cgroup.id">
    The ID common to all cgroups associated with this task. If there isn't a common ID used by all cgroups this field will be absent.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.path">
    The path to the cgroup relative to the cgroup subsystem's mountpoint. If there isn't a common path used by all cgroups this field will be absent.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.cgroups_version">
    The version of cgroups reported for the process
    type: long
  </definition>
</definitions>


## cpu

The cpu subsystem schedules CPU access for tasks in the cgroup. Access can be controlled by two separate schedulers, CFS and RT. CFS stands for completely fair scheduler which proportionally divides the CPU time between cgroups based on weight. RT stands for real time scheduler which sets a maximum amount of CPU time that processes in the cgroup can consume during a given period. In CPU under cgroups V2, the cgroup is merged with many of the metrics from cpuacct. In addition, per-scheduler metrics are gone in V2.
<definitions>
  <definition term="system.process.cgroup.cpu.id">
    ID of the cgroup.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.cpu.path">
    Path to the cgroup relative to the cgroup subsystem's mountpoint.
    type: keyword
  </definition>
</definitions>


## stats

cgroupv2 stats
<definitions>
  <definition term="system.process.cgroup.cpu.stats.usage.ns">
    cgroups v2 usage in nanoseconds
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.usage.pct">
    cgroups v2 usage
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.stats.usage.norm.pct">
    cgroups v2 normalized usage
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.stats.user.ns">
    cgroups v2 cpu user time in nanoseconds
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.user.pct">
    cgroups v2 cpu user time
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.stats.user.norm.pct">
    cgroups v2 normalized cpu user time
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.stats.system.ns">
    cgroups v2 system time in nanoseconds
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.system.pct">
    cgroups v2 system time
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.stats.system.norm.pct">
    cgroups v2 normalized system time
    type: float
  </definition>
  <definition term="system.process.cgroup.cpu.cfs.period.us">
    Period of time in microseconds for how regularly a cgroup's access to CPU resources should be reallocated.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.cfs.quota.us">
    Total amount of time in microseconds for which all tasks in a cgroup can run during one period (as defined by cfs.period.us).
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.cfs.shares">
    An integer value that specifies a relative share of CPU time available to the tasks in a cgroup. The value specified in the cpu.shares file must be 2 or higher.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.rt.period.us">
    Period of time in microseconds for how regularly a cgroup's access to CPU resources is reallocated.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.rt.runtime.us">
    Period of time in microseconds for the longest continuous period in which the tasks in a cgroup have access to CPU resources.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.periods">
    Number of period intervals (as specified in cpu.cfs.period.us) that have elapsed.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.throttled.periods">
    Number of times tasks in a cgroup have been throttled (that is, not allowed to run because they have exhausted all of the available time as specified by their quota).
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.throttled.us">
    The total time duration (in microseconds) for which tasks in a cgroup have been throttled, as reported by cgroupsv2
    type: long
  </definition>
  <definition term="system.process.cgroup.cpu.stats.throttled.ns">
    The total time duration (in nanoseconds) for which tasks in a cgroup have been throttled.
    type: long
  </definition>
</definitions>


## pressure

Pressure (resource contention) stats.

## some

Share of time in which at least some tasks are stalled on a given resource
<definitions>
  <definition term="system.process.cgroup.cpu.pressure.some.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.some.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.some.300.pct">
    Pressure over 300 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.some.total">
    total Some pressure time
    type: long
    format: percent
  </definition>
</definitions>


## full

Share of time in which all non-idle tasks are stalled on a given resource simultaneously
<definitions>
  <definition term="system.process.cgroup.cpu.pressure.full.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.full.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.full.300.pct">
    Pressure over 300 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.cpu.pressure.full.total">
    total Full pressure time
    type: long
  </definition>
</definitions>


## cpuacct

CPU accounting metrics.
<definitions>
  <definition term="system.process.cgroup.cpuacct.id">
    ID of the cgroup.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.cpuacct.path">
    Path to the cgroup relative to the cgroup subsystem's mountpoint.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.cpuacct.total.ns">
    Total CPU time in nanoseconds consumed by all tasks in the cgroup.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpuacct.total.pct">
    CPU time of the cgroup as a percentage of overall CPU time.
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.total.norm.pct">
    CPU time of the cgroup as a percentage of overall CPU time, normalized by CPU count. This is functionally an average of time spent across individual CPUs.
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.user.ns">
    CPU time consumed by tasks in user mode.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.user.pct">
    time the cgroup spent in user space, as a percentage of total CPU time
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.user.norm.pct">
    time the cgroup spent in user space, as a percentage of total CPU time, normalized by CPU count.
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.system.ns">
    CPU time consumed by tasks in user (kernel) mode.
    type: long
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.system.pct">
    Time the cgroup spent in kernel space, as a percentage of total CPU time
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.stats.system.norm.pct">
    Time the cgroup spent in kernel space, as a percentage of total CPU time, normalized by CPU count.
    type: scaled_float
  </definition>
  <definition term="system.process.cgroup.cpuacct.percpu">
    CPU time (in nanoseconds) consumed on each CPU by all tasks in this cgroup.
    type: object
  </definition>
</definitions>


## memory

Memory limits and metrics.
<definitions>
  <definition term="system.process.cgroup.memory.id">
    ID of the cgroup.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.memory.path">
    Path to the cgroup relative to the cgroup subsystem's mountpoint.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.memory.mem.usage.bytes">
    Total memory usage by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.mem.usage.max.bytes">
    The maximum memory used by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.mem.limit.bytes">
    The maximum amount of user memory in bytes (including file cache) that tasks in the cgroup are allowed to use.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.mem.failures">
    The number of times that the memory limit (mem.limit.bytes) was reached.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.low.bytes">
    memory low threshhold
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.mem.high.bytes">
    memory high threshhold
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.mem.max.bytes">
    memory max threshhold
    type: long
    format: bytes
  </definition>
</definitions>


## mem.events

number of times the controller tripped a given usage level
<definitions>
  <definition term="system.process.cgroup.memory.mem.events.low">
    low threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.events.high">
    high threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.events.max">
    max threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.events.oom">
    oom threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.events.oom_kill">
    oom killer threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.mem.events.fail">
    failed threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.usage.bytes">
    The sum of current memory usage plus swap space used by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.usage.max.bytes">
    The maximum amount of memory and swap space used by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.limit.bytes">
    The maximum amount for the sum of memory and swap usage that tasks in the cgroup are allowed to use.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.low.bytes">
    memory low threshhold
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.high.bytes">
    memory high threshhold
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.max.bytes">
    memory max threshhold
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.memsw.failures">
    The number of times that the memory plus swap space limit (memsw.limit.bytes) was reached.
    type: long
  </definition>
</definitions>


## memsw.events

number of times the controller tripped a given usage level
<definitions>
  <definition term="system.process.cgroup.memory.memsw.events.low">
    low threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.events.high">
    high threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.events.max">
    max threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.events.oom">
    oom threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.events.oom_kill">
    oom killer threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.memsw.events.fail">
    failed threshold
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.kmem.usage.bytes">
    Total kernel memory usage by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem.usage.max.bytes">
    The maximum kernel memory used by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem.limit.bytes">
    The maximum amount of kernel memory that tasks in the cgroup are allowed to use.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem.failures">
    The number of times that the memory limit (kmem.limit.bytes) was reached.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.kmem_tcp.usage.bytes">
    Total memory usage for TCP buffers in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem_tcp.usage.max.bytes">
    The maximum memory used for TCP buffers by processes in the cgroup (in bytes).
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem_tcp.limit.bytes">
    The maximum amount of memory for TCP buffers that tasks in the cgroup are allowed to use.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.kmem_tcp.failures">
    The number of times that the memory limit (kmem_tcp.limit.bytes) was reached.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.stats.*">
    detailed memory IO stats
    type: object
  </definition>
  <definition term="system.process.cgroup.memory.stats.*.bytes">
    detailed memory IO stats
    type: object
  </definition>
  <definition term="system.process.cgroup.memory.stats.active_anon.bytes">
    Anonymous and swap cache on active least-recently-used (LRU) list, including tmpfs (shmem), in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.active_file.bytes">
    File-backed memory on active LRU list, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.cache.bytes">
    Page cache, including tmpfs (shmem), in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.hierarchical_memory_limit.bytes">
    Memory limit for the hierarchy that contains the memory cgroup, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.hierarchical_memsw_limit.bytes">
    Memory plus swap limit for the hierarchy that contains the memory cgroup, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.inactive_anon.bytes">
    Anonymous and swap cache on inactive LRU list, including tmpfs (shmem), in bytes
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.inactive_file.bytes">
    File-backed memory on inactive LRU list, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.mapped_file.bytes">
    Size of memory-mapped mapped files, including tmpfs (shmem), in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.page_faults">
    Number of times that a process in the cgroup triggered a page fault.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.stats.major_page_faults">
    Number of times that a process in the cgroup triggered a major fault. "Major" faults happen when the kernel actually has to read the data from disk.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.stats.pages_in">
    Number of pages paged into memory. This is a counter.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.stats.pages_out">
    Number of pages paged out of memory. This is a counter.
    type: long
  </definition>
  <definition term="system.process.cgroup.memory.stats.rss.bytes">
    Anonymous and swap cache (includes transparent hugepages), not including tmpfs (shmem), in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.rss_huge.bytes">
    Number of bytes of anonymous transparent hugepages.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.swap.bytes">
    Swap usage, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.memory.stats.unevictable.bytes">
    Memory that cannot be reclaimed, in bytes.
    type: long
    format: bytes
  </definition>
</definitions>


## pressure

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Pressure (resource contention) stats.

## some

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Share of time in which at least some tasks are stalled on a given resource
<definitions>
  <definition term="system.process.cgroup.memory.pressure.some.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.some.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.some.300.pct">
    Pressure over 300 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.some.total">
    total Some pressure time
    type: long
  </definition>
</definitions>


## full

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Share of time in which all non-idle tasks are stalled on a given resource simultaneously
<definitions>
  <definition term="system.process.cgroup.memory.pressure.full.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.full.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.full.300.pct">
    Pressure over 300 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.memory.pressure.full.total">
    total Full pressure time
    type: long
  </definition>
</definitions>


## blkio

Block IO metrics.
<definitions>
  <definition term="system.process.cgroup.blkio.id">
    ID of the cgroup.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.blkio.path">
    Path to the cgroup relative to the cgroup subsystems mountpoint.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.blkio.total.bytes">
    Total number of bytes transferred to and from all block devices by processes in the cgroup.
    type: long
    format: bytes
  </definition>
  <definition term="system.process.cgroup.blkio.total.ios">
    Total number of I/O operations performed on all devices by processes in the cgroup as seen by the throttling policy.
    type: long
  </definition>
</definitions>


## io

cgroup V2 IO Metrics, replacing blkio.
<definitions>
  <definition term="system.process.cgroup.io.id">
    ID of the cgroup.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.io.path">
    Path to the cgroup relative to the cgroup subsystems mountpoint.
    type: keyword
  </definition>
  <definition term="system.process.cgroup.io.stats.*">
    per-device IO usage stats
    type: object
  </definition>
  <definition term="system.process.cgroup.io.stats.*.*">
    type: object
  </definition>
  <definition term="system.process.cgroup.io.stats.*.*.bytes">
    per-device IO usage stats
    type: object
  </definition>
  <definition term="system.process.cgroup.io.stats.*.*.ios">
    per-device IO usage stats
    type: object
  </definition>
</definitions>


## pressure

Pressure (resource contention) stats.

## full

Share of time in which at least some tasks are stalled on a given resource
<definitions>
  <definition term="system.process.cgroup.io.pressure.full.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.io.pressure.full.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.io.pressure.full.300.pct">
    Pressure over 300 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.io.pressure.full.total">
    total Some pressure time
    type: long
  </definition>
</definitions>


## some

Share of time in which all tasks are stalled on a given resource
<definitions>
  <definition term="system.process.cgroup.io.pressure.some.10.pct">
    Pressure over 10 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.io.pressure.some.60.pct">
    Pressure over 60 seconds
    type: float
    format: percent
  </definition>
  <definition term="system.process.cgroup.io.pressure.some.300.pct">
    Pressure over 300 seconds
    type: float
  </definition>
  <definition term="system.process.cgroup.io.pressure.some.total">
    total Some pressure time
    type: long
  </definition>
</definitions>


## process.summary

Summary metrics for the processes running on the host.
<definitions>
  <definition term="system.process.summary.total">
    Total number of processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.running">
    Number of running processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.idle">
    Number of idle processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.sleeping">
    Number of sleeping processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.stopped">
    Number of stopped processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.zombie">
    Number of zombie processes on this host.
    type: long
  </definition>
  <definition term="system.process.summary.dead">
    Number of dead processes on this host. It's very unlikely that it will appear but in some special situations it may happen.
    type: long
  </definition>
  <definition term="system.process.summary.wakekill">
    Number of wakekill-state processes on this host. Only found on older Linux Kernel versions.
    type: long
  </definition>
  <definition term="system.process.summary.wake">
    Number of wake-state processes on this host. Only found on older Linux Kernel versions.
    type: long
  </definition>
  <definition term="system.process.summary.parked">
    Number of parked-state processes on this host. Only found on older Linux Kernel versions, or under certain conditions.
    type: long
  </definition>
  <definition term="system.process.summary.unknown">
    Number of processes for which the state couldn't be retrieved or is unknown.
    type: long
  </definition>
</definitions>


## threads

Counts of individual threads on a system.
<definitions>
  <definition term="system.process.summary.threads.running">
    Count of currently running threads.
    type: long
  </definition>
  <definition term="system.process.summary.threads.blocked">
    Count of threads blocked by I/O.
    type: long
  </definition>
</definitions>


## raid

raid
<definitions>
  <definition term="system.raid.name">
    Name of the device.
    type: keyword
  </definition>
  <definition term="system.raid.status">
    activity-state of the device.
    type: keyword
  </definition>
  <definition term="system.raid.level">
    The raid level of the device
    type: keyword
  </definition>
  <definition term="system.raid.sync_action">
    Current sync action, if the RAID array is redundant
    type: keyword
  </definition>
  <definition term="system.raid.disks.active">
    Number of active disks.
    type: long
  </definition>
  <definition term="system.raid.disks.total">
    Total number of disks the device consists of.
    type: long
  </definition>
  <definition term="system.raid.disks.spare">
    Number of spared disks.
    type: long
  </definition>
  <definition term="system.raid.disks.failed">
    Number of failed disks.
    type: long
  </definition>
  <definition term="system.raid.disks.states.*">
    map of raw disk states
    type: object
  </definition>
  <definition term="system.raid.blocks.total">
    Number of blocks the device holds, in 1024-byte blocks.
    type: long
  </definition>
  <definition term="system.raid.blocks.synced">
    Number of blocks on the device that are in sync, in 1024-byte blocks.
    type: long
  </definition>
</definitions>


## service

<applies-to>
  - Elastic Stack: Beta
</applies-to>

metrics for system services
<definitions>
  <definition term="system.service.name">
    The name of the service
    type: keyword
  </definition>
  <definition term="system.service.load_state">
    The load state of the service
    type: keyword
  </definition>
  <definition term="system.service.state">
    The activity state of the service
    type: keyword
  </definition>
  <definition term="system.service.sub_state">
    The sub-state of the service
    type: keyword
  </definition>
  <definition term="system.service.state_since">
    The timestamp of the last state change. If the service is active and running, this is its uptime.
    type: date
  </definition>
  <definition term="system.service.exec_code">
    The SIGCHLD code from the service's main process
    type: keyword
  </definition>
  <definition term="system.service.unit_file.state">
    The state of the unit file
    type: keyword
  </definition>
  <definition term="system.service.unit_file.vendor_preset">
    The default state of the unit file
    type: keyword
  </definition>
</definitions>


## resources

system metrics associated with the service
<definitions>
  <definition term="system.service.resources.cpu.usage.ns">
    CPU usage in nanoseconds
    type: long
  </definition>
  <definition term="system.service.resources.memory.usage.bytes">
    memory usage in bytes
    type: long
  </definition>
  <definition term="system.service.resources.tasks.count">
    number of tasks associated with the service
    type: long
  </definition>
</definitions>


## network

network resource usage
<definitions>
  <definition term="system.service.resources.network.in.bytes">
    bytes in
    type: long
    format: bytes
  </definition>
  <definition term="system.service.resources.network.in.packets">
    packets in
    type: long
    format: bytes
  </definition>
  <definition term="system.service.resources.network.out.packets">
    packets out
    type: long
  </definition>
  <definition term="system.service.resources.network.out.bytes">
    bytes out
    type: long
  </definition>
</definitions>


## socket

TCP sockets that are active.
<definitions>
  <definition term="system.socket.direction">
    type: alias
    alias to: network.direction
  </definition>
  <definition term="system.socket.family">
    type: alias
    alias to: network.type
  </definition>
  <definition term="system.socket.local.ip">
    Local IP address. This can be an IPv4 or IPv6 address.
    type: ip
    example: 192.0.2.1 or 2001:0DB8:ABED:8536::1
  </definition>
  <definition term="system.socket.local.port">
    Local port.
    type: long
    example: 22
  </definition>
  <definition term="system.socket.remote.ip">
    Remote IP address. This can be an IPv4 or IPv6 address.
    type: ip
    example: 192.0.2.1 or 2001:0DB8:ABED:8536::1
  </definition>
  <definition term="system.socket.remote.port">
    Remote port.
    type: long
    example: 22
  </definition>
  <definition term="system.socket.remote.host">
    PTR record associated with the remote IP. It is obtained via reverse IP lookup.
    type: keyword
    example: 76-211-117-36.nw.example.com.
  </definition>
  <definition term="system.socket.remote.etld_plus_one">
    The effective top-level domain (eTLD) of the remote host plus one more label. For example, the eTLD+1 for "foo.bar.golang.org." is "golang.org.". The data for determining the eTLD comes from an embedded copy of the data from http://publicsuffix.org.
    type: keyword
    example: example.com.
  </definition>
  <definition term="system.socket.remote.host_error">
    Error describing the cause of the reverse lookup failure.
    type: keyword
  </definition>
  <definition term="system.socket.process.pid">
    type: alias
    alias to: process.pid
  </definition>
  <definition term="system.socket.process.command">
    type: alias
    alias to: process.name
  </definition>
  <definition term="system.socket.process.cmdline">
    Full command line
    type: keyword
  </definition>
  <definition term="system.socket.process.exe">
    type: alias
    alias to: process.executable
  </definition>
  <definition term="system.socket.user.id">
    type: alias
    alias to: user.id
  </definition>
  <definition term="system.socket.user.name">
    type: alias
    alias to: user.full_name
  </definition>
</definitions>


## socket.summary

Summary metrics of open sockets in the host system

## all

All connections
<definitions>
  <definition term="system.socket.summary.all.count">
    All open connections
    type: integer
  </definition>
  <definition term="system.socket.summary.all.listening">
    All listening ports
    type: integer
  </definition>
</definitions>


## tcp

All TCP connections
<definitions>
  <definition term="system.socket.summary.tcp.memory">
    Memory used by TCP sockets in bytes, based on number of allocated pages and system page size. Corresponds to limits set in /proc/sys/net/ipv4/tcp_mem. Only available on Linux.
    type: integer
    format: bytes
  </definition>
</definitions>


## all

All TCP connections
<definitions>
  <definition term="system.socket.summary.tcp.all.orphan">
    A count of all orphaned tcp sockets. Only available on Linux.
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.count">
    All open TCP connections
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.listening">
    All TCP listening ports
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.established">
    Number of established TCP connections
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.close_wait">
    Number of TCP connections in _close_wait_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.time_wait">
    Number of TCP connections in _time_wait_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.syn_sent">
    Number of TCP connections in _syn_sent_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.syn_recv">
    Number of TCP connections in _syn_recv_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.fin_wait1">
    Number of TCP connections in _fin_wait1_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.fin_wait2">
    Number of TCP connections in _fin_wait2_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.last_ack">
    Number of TCP connections in _last_ack_ state
    type: integer
  </definition>
  <definition term="system.socket.summary.tcp.all.closing">
    Number of TCP connections in _closing_ state
    type: integer
  </definition>
</definitions>


## udp

All UDP connections
<definitions>
  <definition term="system.socket.summary.udp.memory">
    Memory used by UDP sockets in bytes, based on number of allocated pages and system page size. Corresponds to limits set in /proc/sys/net/ipv4/udp_mem. Only available on Linux.
    type: integer
    format: bytes
  </definition>
</definitions>


## all

All UDP connections
<definitions>
  <definition term="system.socket.summary.udp.all.count">
    All open UDP connections
    type: integer
  </definition>
</definitions>


## uptime

`uptime` contains the operating system uptime metric.
<definitions>
  <definition term="system.uptime.duration.ms">
    The OS uptime in milliseconds.
    type: long
    format: duration
  </definition>
</definitions>


## users

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Logged-in user session data
<definitions>
  <definition term="system.users.id">
    The ID of the session
    type: keyword
  </definition>
  <definition term="system.users.seat">
    An associated logind seat
    type: keyword
  </definition>
  <definition term="system.users.path">
    The DBus object path of the session
    type: keyword
  </definition>
  <definition term="system.users.type">
    The type of the user session
    type: keyword
  </definition>
  <definition term="system.users.service">
    A session associated with the service
    type: keyword
  </definition>
  <definition term="system.users.remote">
    A bool indicating a remote session
    type: boolean
  </definition>
  <definition term="system.users.state">
    The current state of the session
    type: keyword
  </definition>
  <definition term="system.users.scope">
    The associated systemd scope
    type: keyword
  </definition>
  <definition term="system.users.leader">
    The root PID of the session
    type: long
  </definition>
  <definition term="system.users.remote_host">
    A remote host address for the session
    type: keyword
  </definition>
</definitions>