﻿---
title: SyncGateway fields
description: SyncGateway metrics syncgateway contains the information and statistics from SyncGateway. Couchbase Sync Gateway metrics. Metrics of all databases contained...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-syncgateway
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# SyncGateway fields
SyncGateway metrics

## syncgateway

`syncgateway` contains the information and statistics from SyncGateway.

## syncgateway

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Couchbase Sync Gateway metrics.
<definitions>
  <definition term="syncgateway.syncgateway.name">
    Name of the database on when field `couchbase.syncgateway.type` is `db_stats`.
    type: keyword
  </definition>
</definitions>


## metrics

Metrics of all databases contained in the config file of the SyncGateway instance.
<definitions>
  <definition term="syncgateway.syncgateway.metrics.docs.writes.conflict.count">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.metrics.docs.writes.count">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.metrics.docs.writes.bytes">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.metrics.replications.active">
    Number of active replications
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.metrics.replications.total">
    Total number of replications (active or not)
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.tombstones.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.tombstones.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.tombstones.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.access.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.access.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.access.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.star.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.star.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.channels.star.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.role_access.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.role_access.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.role_access.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sequences.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sequences.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sequences.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.all_docs.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.all_docs.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.all_docs.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.principals.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.principals.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.principals.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.resync.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.resync.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.resync.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sessions.query.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sessions.query.error.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.gsi.views.sessions.query.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.security.access_errors.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.security.auth.failed.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.security.docs_rejected.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.channel.revs.active">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.channel.revs.removal">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.channel.revs.tombstone">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.channel.hits">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.channel.misses">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.revs.hits">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cache.revs.misses">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.caught_up">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.since_zero">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.total.continuous">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.total.one_shot">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.active.continuous">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.active.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.active.one_shot">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.attachment.bytes">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.attachment.count">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.request_changes.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.request_changes.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.rev.processing_time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.rev.send.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.pull.rev.send.latency">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.attachment.bytes">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.attachment.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.doc_push_count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.propose_change.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.propose_change.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.sync_function.count">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.sync_function.time">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.cbl.replication.push.write_processing_time">
    type: double
  </definition>
</definitions>


## memstats

Dumps a large amount of information about the memory heap and garbage collector
<definitions>
  <definition term="syncgateway.syncgateway.memstats.BuckHashSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.Mallocs">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.PauseTotalNs">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.TotalAlloc">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.Alloc">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.GCSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.LastGC">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.MSpanSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.GCCPUFraction">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapReleased">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.DebugGC">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapIdle">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.Lookups">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapObjects">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.MSpanInuse">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.NumForcedGC">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.OtherSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.Frees">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.NextGC">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.StackInuse">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.Sys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.NumGC">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.EnableGC">
    type: long
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapAlloc">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.MCacheInuse">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.MCacheSys">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.HeapInuse">
    type: double
  </definition>
  <definition term="syncgateway.syncgateway.memstats.StackSys">
    type: double
  </definition>
</definitions>


## memory

<applies-to>
  - Elastic Stack: Beta
</applies-to>

SyncGateway memory metrics. It dumps a large amount of information about the memory heap and garbage collector
<definitions>
  <definition term="syncgateway.memory.BuckHashSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.Mallocs">
    type: double
  </definition>
  <definition term="syncgateway.memory.PauseTotalNs">
    type: double
  </definition>
  <definition term="syncgateway.memory.TotalAlloc">
    type: double
  </definition>
  <definition term="syncgateway.memory.Alloc">
    type: double
  </definition>
  <definition term="syncgateway.memory.GCSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.LastGC">
    type: double
  </definition>
  <definition term="syncgateway.memory.MSpanSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.GCCPUFraction">
    type: double
  </definition>
  <definition term="syncgateway.memory.HeapReleased">
    type: double
  </definition>
  <definition term="syncgateway.memory.HeapSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.DebugGC">
    type: long
  </definition>
  <definition term="syncgateway.memory.HeapIdle">
    type: double
  </definition>
  <definition term="syncgateway.memory.Lookups">
    type: double
  </definition>
  <definition term="syncgateway.memory.HeapObjects">
    type: double
  </definition>
  <definition term="syncgateway.memory.MSpanInuse">
    type: double
  </definition>
  <definition term="syncgateway.memory.NumForcedGC">
    type: double
  </definition>
  <definition term="syncgateway.memory.OtherSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.Frees">
    type: double
  </definition>
  <definition term="syncgateway.memory.NextGC">
    type: double
  </definition>
  <definition term="syncgateway.memory.StackInuse">
    type: double
  </definition>
  <definition term="syncgateway.memory.Sys">
    type: double
  </definition>
  <definition term="syncgateway.memory.NumGC">
    type: double
  </definition>
  <definition term="syncgateway.memory.EnableGC">
    type: long
  </definition>
  <definition term="syncgateway.memory.HeapAlloc">
    type: double
  </definition>
  <definition term="syncgateway.memory.MCacheInuse">
    type: double
  </definition>
  <definition term="syncgateway.memory.MCacheSys">
    type: double
  </definition>
  <definition term="syncgateway.memory.HeapInuse">
    type: double
  </definition>
  <definition term="syncgateway.memory.StackSys">
    type: double
  </definition>
</definitions>


## replication

<applies-to>
  - Elastic Stack: Beta
</applies-to>

SyncGateway per replication metrics.

## metrics

Metrics related with data replication.
<definitions>
  <definition term="syncgateway.replication.metrics.attachment.transferred.bytes">
    Number of attachment bytes transferred for this replica.
    type: long
  </definition>
  <definition term="syncgateway.replication.metrics.attachment.transferred.count">
    The total number of attachments transferred since replication started.
    type: long
  </definition>
  <definition term="syncgateway.replication.metrics.docs.checked_sent">
    The total number of documents checked for changes since replication started.
    type: double
  </definition>
  <definition term="syncgateway.replication.metrics.docs.pushed.count">
    The total number of documents checked for changes since replication started.
    type: long
  </definition>
  <definition term="syncgateway.replication.metrics.docs.pushed.failed">
    The total number of documents that failed to be pushed since replication started.
    type: long
  </definition>
  <definition term="syncgateway.replication.id">
    ID of the replica.
    type: keyword
  </definition>
</definitions>


## resources

<applies-to>
  - Elastic Stack: Beta
</applies-to>

SyncGateway global resource utilization
<definitions>
  <definition term="syncgateway.resources.error_count">
    type: long
  </definition>
  <definition term="syncgateway.resources.goroutines_high_watermark">
    type: long
  </definition>
  <definition term="syncgateway.resources.num_goroutines">
    type: long
  </definition>
  <definition term="syncgateway.resources.process.cpu_percent_utilization">
    type: long
  </definition>
  <definition term="syncgateway.resources.process.memory_resident">
    type: long
  </definition>
  <definition term="syncgateway.resources.pub_net.recv.bytes">
    type: long
  </definition>
  <definition term="syncgateway.resources.pub_net.sent.bytes">
    type: long
  </definition>
  <definition term="syncgateway.resources.admin_net_bytes.recv">
    type: long
  </definition>
  <definition term="syncgateway.resources.admin_net_bytes.sent">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.heap.alloc">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.heap.idle">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.heap.inuse">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.heap.released">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.pause.ns">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.stack.inuse">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.stack.sys">
    type: long
  </definition>
  <definition term="syncgateway.resources.go_memstats.sys">
    type: long
  </definition>
  <definition term="syncgateway.resources.system_memory_total">
    type: long
  </definition>
  <definition term="syncgateway.resources.warn_count">
    type: long
  </definition>
</definitions>