﻿---
title: Stan fields
description: stan Module stan contains statistics that were read from Nats Streaming server (STAN) Contains stan / nats streaming/serverz endpoint metrics Contains...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-stan
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Stan fields
stan Module

## stan

`stan` contains statistics that were read from Nats Streaming server (STAN)
<definitions>
  <definition term="stan.server.id">
    The server ID
    type: keyword
  </definition>
  <definition term="stan.cluster.id">
    The cluster ID
    type: keyword
  </definition>
</definitions>


## channels

Contains stan / nats streaming/serverz endpoint metrics
<definitions>
  <definition term="stan.channels.name">
    The name of the STAN streaming channel
    type: keyword
  </definition>
  <definition term="stan.channels.messages">
    The number of STAN streaming messages
    type: long
  </definition>
  <definition term="stan.channels.bytes">
    The number of STAN bytes in the channel
    type: long
  </definition>
  <definition term="stan.channels.first_seq">
    First sequence number stored in the channel. If first_seq > min([seq in subscriptions]) data loss has possibly occurred
    type: long
  </definition>
  <definition term="stan.channels.last_seq">
    Last sequence number stored in the channel
    type: long
  </definition>
  <definition term="stan.channels.depth">
    Queue depth based upon current sequence number and highest reported subscriber sequence number
    type: long
  </definition>
</definitions>


## stats

Contains only high-level stan / nats streaming server related metrics
<definitions>
  <definition term="stan.stats.state">
    The cluster / streaming configuration state (STANDALONE, CLUSTERED)
    type: keyword
  </definition>
  <definition term="stan.stats.role">
    If clustered, role of this node in the cluster (Leader, Follower, Candidate)
    type: keyword
  </definition>
  <definition term="stan.stats.clients">
    The number of STAN clients
    type: integer
  </definition>
  <definition term="stan.stats.subscriptions">
    The number of STAN streaming subscriptions
    type: integer
  </definition>
  <definition term="stan.stats.channels">
    The number of STAN channels
    type: integer
  </definition>
  <definition term="stan.stats.messages">
    Number of messages across all STAN queues
    type: long
  </definition>
  <definition term="stan.stats.bytes">
    Number of bytes consumed across all STAN queues
    type: long
  </definition>
</definitions>


## subscriptions

Contains stan / nats streaming/serverz endpoint subscription metrics
<definitions>
  <definition term="stan.subscriptions.id">
    The name of the STAN channel subscription (client_id)
    type: keyword
  </definition>
  <definition term="stan.subscriptions.channel">
    The name of the STAN channel the subscription is associated with
    type: keyword
  </definition>
  <definition term="stan.subscriptions.queue">
    The name of the NATS queue that the STAN channel subscription is associated with, if any
    type: keyword
  </definition>
  <definition term="stan.subscriptions.last_sent">
    Last known sequence number of the subscription that was acked
    type: long
  </definition>
  <definition term="stan.subscriptions.pending">
    Number of pending messages from / to the subscriber
    type: long
  </definition>
  <definition term="stan.subscriptions.offline">
    Is the subscriber marked as offline?
    type: boolean
  </definition>
  <definition term="stan.subscriptions.stalled">
    Is the subscriber known to be stalled?
    type: boolean
  </definition>
</definitions>