﻿---
title: Redis fields
description: Redis metrics collected from Redis. redis contains the information and statistics from Redis. info contains the information and statistics returned by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-redis
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Redis fields
Redis metrics collected from Redis.

## redis

`redis` contains the information and statistics from Redis.

## info

`info` contains the information and statistics returned by the `INFO` command.

## clients

Redis client stats.
<definitions>
  <definition term="redis.info.clients.connected">
    Number of client connections (excluding connections from slaves).
    type: long
  </definition>
  <definition term="redis.info.clients.max_output_buffer">
    Longest output list among current client connections.
    type: long
  </definition>
  <definition term="redis.info.clients.max_input_buffer">
    Biggest input buffer among current client connections (on redis 5.0).
    type: long
  </definition>
  <definition term="redis.info.clients.blocked">
    Number of clients pending on a blocking call (BLPOP, BRPOP, BRPOPLPUSH).
    type: long
  </definition>
</definitions>


## cluster

Redis cluster information.
<definitions>
  <definition term="redis.info.cluster.enabled">
    Indicates that the Redis cluster is enabled.
    type: boolean
  </definition>
</definitions>


## cpu

Redis CPU stats
<definitions>
  <definition term="redis.info.cpu.used.sys">
    System CPU consumed by the Redis server.
    type: scaled_float
  </definition>
  <definition term="redis.info.cpu.used.sys_children">
    System CPU consumed by the background processes.
    type: scaled_float
  </definition>
  <definition term="redis.info.cpu.used.user">
    User CPU consumed by the Redis server.
    type: scaled_float
  </definition>
  <definition term="redis.info.cpu.used.user_children">
    User CPU consumed by the background processes.
    type: scaled_float
  </definition>
</definitions>


## memory

Redis memory stats.
<definitions>
  <definition term="redis.info.memory.used.value">
    Total number of bytes allocated by Redis.
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.used.rss">
    Number of bytes that Redis allocated as seen by the operating system (a.k.a resident set size).
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.used.peak">
    Peak memory consumed by Redis.
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.used.lua">
    Used memory by the Lua engine.
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.used.dataset">
    The size in bytes of the dataset
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.max.value">
    Memory limit.
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.max.policy">
    Eviction policy to use when memory limit is reached.
    type: keyword
  </definition>
  <definition term="redis.info.memory.fragmentation.ratio">
    Ratio between used_memory_rss and used_memory
    type: float
  </definition>
  <definition term="redis.info.memory.fragmentation.bytes">
    Bytes between used_memory_rss and used_memory
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.active_defrag.is_running">
    Flag indicating if active defragmentation is active
    type: boolean
  </definition>
  <definition term="redis.info.memory.allocator">
    Memory allocator.
    type: keyword
  </definition>
  <definition term="redis.info.memory.allocator_stats.allocated">
    Allocated memory
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.allocator_stats.active">
    Active memory
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.allocator_stats.resident">
    Resident memory
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.allocator_stats.fragmentation.ratio">
    Fragmentation ratio
    type: float
  </definition>
  <definition term="redis.info.memory.allocator_stats.fragmentation.bytes">
    Fragmented bytes
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.memory.allocator_stats.rss.ratio">
    Resident ratio
    type: float
  </definition>
  <definition term="redis.info.memory.allocator_stats.rss.bytes">
    Resident bytes
    type: long
    format: bytes
  </definition>
</definitions>


## persistence

Redis CPU stats.
<definitions>
  <definition term="redis.info.persistence.loading">
    Flag indicating if the load of a dump file is on-going
    type: boolean
  </definition>
</definitions>


## rdb

Provides information about RDB persistence
<definitions>
  <definition term="redis.info.persistence.rdb.last_save.changes_since">
    Number of changes since the last dump
    type: long
  </definition>
  <definition term="redis.info.persistence.rdb.last_save.time">
    Epoch-based timestamp of last successful RDB save
    type: long
  </definition>
  <definition term="redis.info.persistence.rdb.bgsave.in_progress">
    Flag indicating a RDB save is on-going
    type: boolean
  </definition>
  <definition term="redis.info.persistence.rdb.bgsave.last_status">
    Status of the last RDB save operation
    type: keyword
  </definition>
  <definition term="redis.info.persistence.rdb.bgsave.last_time.sec">
    Duration of the last RDB save operation in seconds
    type: long
    format: duration
  </definition>
  <definition term="redis.info.persistence.rdb.bgsave.current_time.sec">
    Duration of the on-going RDB save operation if any
    type: long
    format: duration
  </definition>
  <definition term="redis.info.persistence.rdb.copy_on_write.last_size">
    The size in bytes of copy-on-write allocations during the last RBD save operation
    type: long
    format: bytes
  </definition>
</definitions>


## aof

Provides information about AOF persitence
<definitions>
  <definition term="redis.info.persistence.aof.enabled">
    Flag indicating AOF logging is activated
    type: boolean
  </definition>
  <definition term="redis.info.persistence.aof.rewrite.in_progress">
    Flag indicating a AOF rewrite operation is on-going
    type: boolean
  </definition>
  <definition term="redis.info.persistence.aof.rewrite.scheduled">
    Flag indicating an AOF rewrite operation will be scheduled once the on-going RDB save is complete.
    type: boolean
  </definition>
  <definition term="redis.info.persistence.aof.rewrite.last_time.sec">
    Duration of the last AOF rewrite operation in seconds
    type: long
    format: duration
  </definition>
  <definition term="redis.info.persistence.aof.rewrite.current_time.sec">
    Duration of the on-going AOF rewrite operation if any
    type: long
    format: duration
  </definition>
  <definition term="redis.info.persistence.aof.rewrite.buffer.size">
    Size of the AOF rewrite buffer
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.persistence.aof.bgrewrite.last_status">
    Status of the last AOF rewrite operatio
    type: keyword
  </definition>
  <definition term="redis.info.persistence.aof.write.last_status">
    Status of the last write operation to the AOF
    type: keyword
  </definition>
  <definition term="redis.info.persistence.aof.copy_on_write.last_size">
    The size in bytes of copy-on-write allocations during the last RBD save operation
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.persistence.aof.buffer.size">
    Size of the AOF buffer
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.persistence.aof.size.current">
    AOF current file size
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.persistence.aof.size.base">
    AOF file size on latest startup or rewrite
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.persistence.aof.fsync.pending">
    Number of fsync pending jobs in background I/O queue
    type: long
  </definition>
  <definition term="redis.info.persistence.aof.fsync.delayed">
    Delayed fsync counter
    type: long
  </definition>
</definitions>


## replication

Replication
<definitions>
  <definition term="redis.info.replication.role">
    Role of the instance (can be "master", or "slave").
    type: keyword
  </definition>
  <definition term="redis.info.replication.connected_slaves">
    Number of connected slaves
    type: long
  </definition>
  <definition term="redis.info.replication.backlog.active">
    Flag indicating replication backlog is active
    type: long
  </definition>
  <definition term="redis.info.replication.backlog.size">
    Total size in bytes of the replication backlog buffer
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.replication.backlog.first_byte_offset">
    The master offset of the replication backlog buffer
    type: long
  </definition>
  <definition term="redis.info.replication.backlog.histlen">
    Size in bytes of the data in the replication backlog buffer
    type: long
  </definition>
  <definition term="redis.info.replication.master.offset">
    The server's current replication offset
    type: long
  </definition>
  <definition term="redis.info.replication.master.second_offset">
    The offset up to which replication IDs are accepted
    type: long
  </definition>
  <definition term="redis.info.replication.master.link_status">
    Status of the link (up/down)
    type: keyword
  </definition>
  <definition term="redis.info.replication.master.last_io_seconds_ago">
    Number of seconds since the last interaction with master
    type: long
    format: duration
  </definition>
  <definition term="redis.info.replication.master.sync.in_progress">
    Indicate the master is syncing to the slave
    type: boolean
  </definition>
  <definition term="redis.info.replication.master.sync.left_bytes">
    Number of bytes left before syncing is complete
    type: long
    format: bytes
  </definition>
  <definition term="redis.info.replication.master.sync.last_io_seconds_ago">
    Number of seconds since last transfer I/O during a SYNC operation
    type: long
    format: duration
  </definition>
  <definition term="redis.info.replication.slave.offset">
    The replication offset of the slave instance
    type: long
  </definition>
  <definition term="redis.info.replication.slave.priority">
    The priority of the instance as a candidate for failover
    type: long
  </definition>
  <definition term="redis.info.replication.slave.is_readonly">
    Flag indicating if the slave is read-only
    type: boolean
  </definition>
</definitions>


## server

Server info
<definitions>
  <definition term="redis.info.server.version">
    None
    type: alias
    alias to: service.version
  </definition>
  <definition term="redis.info.server.git_sha1">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.git_dirty">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.build_id">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.mode">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.os">
    None
    type: alias
    alias to: os.full
  </definition>
  <definition term="redis.info.server.arch_bits">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.multiplexing_api">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.gcc_version">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.process_id">
    None
    type: alias
    alias to: process.pid
  </definition>
  <definition term="redis.info.server.run_id">
    None
    type: keyword
  </definition>
  <definition term="redis.info.server.tcp_port">
    None
    type: long
  </definition>
  <definition term="redis.info.server.uptime">
    None
    type: long
  </definition>
  <definition term="redis.info.server.hz">
    None
    type: long
  </definition>
  <definition term="redis.info.server.lru_clock">
    None
    type: long
  </definition>
  <definition term="redis.info.server.config_file">
    None
    type: keyword
  </definition>
</definitions>


## stats

Redis stats.
<definitions>
  <definition term="redis.info.stats.connections.received">
    Total number of connections received.
    type: long
  </definition>
  <definition term="redis.info.stats.connections.rejected">
    Total number of connections rejected.
    type: long
  </definition>
  <definition term="redis.info.stats.commands_processed">
    Total number of commands processed.
    type: long
  </definition>
  <definition term="redis.info.stats.net.input.bytes">
    Total network input in bytes.
    type: long
  </definition>
  <definition term="redis.info.stats.net.output.bytes">
    Total network output in bytes.
    type: long
  </definition>
  <definition term="redis.info.stats.instantaneous.ops_per_sec">
    Number of commands processed per second
    type: long
  </definition>
  <definition term="redis.info.stats.instantaneous.input_kbps">
    The network's read rate per second in KB/sec
    type: scaled_float
  </definition>
  <definition term="redis.info.stats.instantaneous.output_kbps">
    The network's write rate per second in KB/sec
    type: scaled_float
  </definition>
  <definition term="redis.info.stats.sync.full">
    The number of full resyncs with slaves
    type: long
  </definition>
  <definition term="redis.info.stats.sync.partial.ok">
    The number of accepted partial resync requests
    type: long
  </definition>
  <definition term="redis.info.stats.sync.partial.err">
    The number of denied partial resync requests
    type: long
  </definition>
  <definition term="redis.info.stats.keys.expired">
    Total number of key expiration events
    type: long
  </definition>
  <definition term="redis.info.stats.keys.evicted">
    Number of evicted keys due to maxmemory limit
    type: long
  </definition>
  <definition term="redis.info.stats.keyspace.hits">
    Number of successful lookup of keys in the main dictionary
    type: long
  </definition>
  <definition term="redis.info.stats.keyspace.misses">
    Number of failed lookup of keys in the main dictionary
    type: long
  </definition>
  <definition term="redis.info.stats.pubsub.channels">
    Global number of pub/sub channels with client subscriptions
    type: long
  </definition>
  <definition term="redis.info.stats.pubsub.patterns">
    Global number of pub/sub pattern with client subscriptions
    type: long
  </definition>
  <definition term="redis.info.stats.latest_fork_usec">
    Duration of the latest fork operation in microseconds
    type: long
  </definition>
  <definition term="redis.info.stats.migrate_cached_sockets">
    The number of sockets open for MIGRATE purposes
    type: long
  </definition>
  <definition term="redis.info.stats.slave_expires_tracked_keys">
    The number of keys tracked for expiry purposes (applicable only to writable slaves)
    type: long
  </definition>
  <definition term="redis.info.stats.active_defrag.hits">
    Number of value reallocations performed by active the defragmentation process
    type: long
  </definition>
  <definition term="redis.info.stats.active_defrag.misses">
    Number of aborted value reallocations started by the active defragmentation process
    type: long
  </definition>
  <definition term="redis.info.stats.active_defrag.key_hits">
    Number of keys that were actively defragmented
    type: long
  </definition>
  <definition term="redis.info.stats.active_defrag.key_misses">
    Number of keys that were skipped by the active defragmentation process
    type: long
  </definition>
  <definition term="redis.info.slowlog.count">
    Count of slow operations
    type: long
  </definition>
</definitions>


## commandstats

Redis command statistics
<definitions>
  <definition term="redis.info.commandstats.*.calls">
    The number of calls that reached command execution (not rejected).
    type: long
  </definition>
  <definition term="redis.info.commandstats.*.usec">
    The total CPU time consumed by these commands.
    type: long
  </definition>
  <definition term="redis.info.commandstats.*.usec_per_call">
    The average CPU consumed per command execution.
    type: float
  </definition>
  <definition term="redis.info.commandstats.*.rejected_calls">
    The number of rejected calls (on redis 6.2-rc2).
    type: long
  </definition>
  <definition term="redis.info.commandstats.*.failed_calls">
    The number of failed calls (on redis 6.2-rc2).
    type: long
  </definition>
</definitions>


## key

`key` contains information about keys.
<definitions>
  <definition term="redis.key.name">
    Key name.
    type: keyword
  </definition>
  <definition term="redis.key.id">
    Unique id for this key (With the form <keyspace>:<name>).
    type: keyword
  </definition>
  <definition term="redis.key.type">
    Key type as shown by `TYPE` command.
    type: keyword
  </definition>
  <definition term="redis.key.length">
    Length of the key (Number of elements for lists, length for strings, cardinality for sets).
    type: long
  </definition>
  <definition term="redis.key.expire.ttl">
    Seconds to expire.
    type: long
  </definition>
</definitions>


## keyspace

`keyspace` contains the information about the keyspaces returned by the `INFO` command.
<definitions>
  <definition term="redis.keyspace.id">
    Keyspace identifier.
    type: keyword
  </definition>
  <definition term="redis.keyspace.avg_ttl">
    Average ttl.
    type: long
  </definition>
  <definition term="redis.keyspace.keys">
    Number of keys in the keyspace.
    type: long
  </definition>
  <definition term="redis.keyspace.expires">
    type: long
  </definition>
</definitions>