﻿---
title: Oracle fields
description: Oracle database module Oracle module Performance related metrics on a single database instance Statistics about all buffer pools available for the instance...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-oracle
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Oracle fields
Oracle database module

## oracle

Oracle module

## performance

Performance related metrics on a single database instance
<definitions>
  <definition term="oracle.performance.machine">
    Operating system machine name
    type: keyword
  </definition>
  <definition term="oracle.performance.buffer_pool">
    Name of the buffer pool in the instance
    type: keyword
  </definition>
  <definition term="oracle.performance.username">
    Oracle username
    type: keyword
  </definition>
  <definition term="oracle.performance.io_reloads">
    Reloads / Pins ratio. A Reload is any PIN of an object that is not the first PIN performed since the object handle was created, and which requires loading the object from disk. Pins are the number of times a PIN was requested for objects of this namespace
    type: double
  </definition>
  <definition term="oracle.performance.lock_requests">
    Average of the ratio between 'gethits' and 'gets' being 'Gethits' the number of times an object's handle was found in memory and 'gets' the number of times a lock was requested for objects of this namespace.
    type: long
  </definition>
  <definition term="oracle.performance.pin_requests">
    Average of all pinhits/pins ratios being 'PinHits' the number of times all of the metadata pieces of the library object were found in memory and 'pins' the number of times a PIN was requested for objects of this namespace
    type: double
  </definition>
</definitions>


## cache

Statistics about all buffer pools available for the instance
<definitions>
  <definition term="oracle.performance.cache.buffer.hit.pct">
    The cache hit ratio of the specified buffer pool.
    type: double
  </definition>
  <definition term="oracle.performance.cache.physical_reads">
    Physical reads
    type: long
  </definition>
</definitions>


## get

Buffer pool 'get' statistics
<definitions>
  <definition term="oracle.performance.cache.get.consistent">
    Consistent gets statistic
    type: long
  </definition>
  <definition term="oracle.performance.cache.get.db_blocks">
    Database blocks gotten
    type: long
  </definition>
</definitions>


## cursors

Cursors information
<definitions>
  <definition term="oracle.performance.cursors.avg">
    Average cursors opened by username and machine
    type: double
  </definition>
  <definition term="oracle.performance.cursors.max">
    Max cursors opened by username and machine
    type: double
  </definition>
  <definition term="oracle.performance.cursors.total">
    Total opened cursors by username and machine
    type: double
  </definition>
</definitions>


## opened

Opened cursors statistic
<definitions>
  <definition term="oracle.performance.cursors.opened.current">
    Total number of current open cursors
    type: long
  </definition>
  <definition term="oracle.performance.cursors.opened.total">
    Total number of cursors opened since the instance started
    type: long
  </definition>
</definitions>


## parse

Parses statistic information that occured in the current session
<definitions>
  <definition term="oracle.performance.cursors.parse.real">
    Real number of parses that occurred: session cursor cache hits - parse count (total)
    type: long
  </definition>
  <definition term="oracle.performance.cursors.parse.total">
    Total number of parse calls (hard and soft). A soft parse is a check on an object already in the shared pool, to verify that the permissions on the underlying object have not changed.
    type: long
  </definition>
  <definition term="oracle.performance.cursors.session.cache_hits">
    Number of hits in the session cursor cache. A hit means that the SQL statement did not have to be reparsed.
    type: long
  </definition>
  <definition term="oracle.performance.cursors.cache_hit.pct">
    Ratio of session cursor cache hits from total number of cursors
    type: double
  </definition>
</definitions>


## sysmetric

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Sysmetric related metrics.
<definitions>
  <definition term="oracle.sysmetric.session_count">
    Session Count.
    type: long
  </definition>
  <definition term="oracle.sysmetric.average_active_sessions">
    Average Active Sessions.
    type: double
  </definition>
  <definition term="oracle.sysmetric.current_os_load">
    Current OS Load.
    type: double
  </definition>
  <definition term="oracle.sysmetric.physical_reads_per_sec">
    Physical Reads Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.user_transaction_per_sec">
    User Transaction Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.total_table_scans_per_txn">
    Total Table Scans Per Transaction.
    type: double
  </definition>
  <definition term="oracle.sysmetric.physical_writes_per_sec">
    Physical Writes Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.total_index_scans_per_txn">
    Total Index Scans Per Transaction.
    type: double
  </definition>
  <definition term="oracle.sysmetric.host_cpu_utilization_pct">
    Host CPU Utilization (%).
    type: double
  </definition>
  <definition term="oracle.sysmetric.network_traffic_volume_per_sec">
    Network Traffic Volume Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.user_rollbacks_per_sec">
    User Rollbacks Per Second.
    type: long
  </definition>
  <definition term="oracle.sysmetric.cpu_usage_per_sec">
    CPU Usage Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.db_block_changes_per_sec">
    DB Block Changes Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.physical_read_total_bytes_per_sec">
    Physical Read Total Bytes Per Second.
    type: double
  </definition>
  <definition term="oracle.sysmetric.response_time_per_txn">
    Response Time Per Transaction.
    type: double
  </definition>
</definitions>


## tablespace

tablespace
<definitions>
  <definition term="oracle.tablespace.name">
    Tablespace name
    type: keyword
  </definition>
</definitions>


## data_file

Database files information
<definitions>
  <definition term="oracle.tablespace.data_file.id">
    Tablespace unique identifier
    type: long
  </definition>
  <definition term="oracle.tablespace.data_file.name">
    Filename of the data file
    type: keyword
  </definition>
</definitions>


## size

Size information about the file
<definitions>
  <definition term="oracle.tablespace.data_file.size.max.bytes">
    Maximum file size in bytes
    type: long
    format: bytes
  </definition>
  <definition term="oracle.tablespace.data_file.size.bytes">
    Size of the file in bytes
    type: long
    format: bytes
  </definition>
  <definition term="oracle.tablespace.data_file.size.free.bytes">
    The size of the file available for user data. The actual size of the file minus this value is used to store file related metadata.
    type: long
    format: bytes
  </definition>
  <definition term="oracle.tablespace.data_file.status">
    'File status: AVAILABLE or INVALID (INVALID means that the file number is not in use, for example, a file in a tablespace that was dropped)'
    type: keyword
  </definition>
  <definition term="oracle.tablespace.data_file.online_status">
    Last known online status of the data file. One of SYSOFF, SYSTEM, OFFLINE, ONLINE or RECOVER.
    type: keyword
  </definition>
</definitions>


## space

Tablespace space usage information
<definitions>
  <definition term="oracle.tablespace.space.free.bytes">
    Tablespace total free space available, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="oracle.tablespace.space.used.bytes">
    Tablespace used space, in bytes.
    type: long
    format: bytes
  </definition>
  <definition term="oracle.tablespace.space.total.bytes">
    Tablespace total size, in bytes.
    type: long
    format: bytes
  </definition>
</definitions>