﻿---
title: Logstash fields
description: Logstash module node node_stats metrics. JVM Info Events stats 
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-logstash
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Logstash fields
Logstash module
<definitions>
  <definition term="logstash_stats.timestamp">
    type: alias
    alias to: @timestamp
  </definition>
  <definition term="logstash_stats.jvm.mem.heap_used_in_bytes">
    type: alias
    alias to: logstash.node.stats.jvm.mem.heap_used_in_bytes
  </definition>
  <definition term="logstash_stats.jvm.mem.heap_max_in_bytes">
    type: alias
    alias to: logstash.node.stats.jvm.mem.heap_max_in_bytes
  </definition>
  <definition term="logstash_stats.jvm.uptime_in_millis">
    type: alias
    alias to: logstash.node.stats.jvm.uptime_in_millis
  </definition>
  <definition term="logstash_stats.events.in">
    type: alias
    alias to: logstash.node.stats.events.in
  </definition>
  <definition term="logstash_stats.events.out">
    type: alias
    alias to: logstash.node.stats.events.out
  </definition>
  <definition term="logstash_stats.events.duration_in_millis">
    type: alias
    alias to: logstash.node.stats.events.duration_in_millis
  </definition>
  <definition term="logstash_stats.logstash.uuid">
    type: alias
    alias to: logstash.node.stats.logstash.uuid
  </definition>
  <definition term="logstash_stats.logstash.version">
    type: alias
    alias to: logstash.node.stats.logstash.version
  </definition>
  <definition term="logstash_stats.pipelines">
    type: nested
  </definition>
  <definition term="logstash_stats.os.cpu.load_average.15m">
    type: alias
    alias to: logstash.node.stats.os.cpu.load_average.15m
  </definition>
  <definition term="logstash_stats.os.cpu.load_average.1m">
    type: alias
    alias to: logstash.node.stats.os.cpu.load_average.1m
  </definition>
  <definition term="logstash_stats.os.cpu.load_average.5m">
    type: alias
    alias to: logstash.node.stats.os.cpu.load_average.5m
  </definition>
  <definition term="logstash_stats.os.cgroup.cpuacct.usage_nanos">
    type: alias
    alias to: logstash.node.stats.os.cgroup.cpuacct.usage_nanos
  </definition>
  <definition term="logstash_stats.os.cgroup.cpu.cfs_quota_micros">
    type: alias
    alias to: logstash.node.stats.os.cgroup.cpu.cfs_quota_micros
  </definition>
  <definition term="logstash_stats.os.cgroup.cpu.stat.number_of_elapsed_periods">
    type: alias
    alias to: logstash.node.stats.os.cgroup.cpu.stat.number_of_elapsed_periods
  </definition>
  <definition term="logstash_stats.os.cgroup.cpu.stat.time_throttled_nanos">
    type: alias
    alias to: logstash.node.stats.os.cgroup.cpu.stat.time_throttled_nanos
  </definition>
  <definition term="logstash_stats.os.cgroup.cpu.stat.number_of_times_throttled">
    type: alias
    alias to: logstash.node.stats.os.cgroup.cpu.stat.number_of_times_throttled
  </definition>
  <definition term="logstash_stats.process.cpu.percent">
    type: alias
    alias to: logstash.node.stats.process.cpu.percent
  </definition>
  <definition term="logstash_stats.queue.events_count">
    type: alias
    alias to: logstash.node.stats.queue.events_count
  </definition>
  <definition term="logstash_state.pipeline.id">
    type: alias
    alias to: logstash.node.state.pipeline.id
  </definition>
  <definition term="logstash_state.pipeline.hash">
    type: alias
    alias to: logstash.node.state.pipeline.hash
  </definition>
  <definition term="logstash.elasticsearch.cluster.id">
    type: keyword
  </definition>
</definitions>


## node

node

## node

node_stats metrics.
<definitions>
  <definition term="logstash.node.id">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.id">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.hash">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.ephemeral_id">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.batch_size">
    type: long
  </definition>
  <definition term="logstash.node.state.pipeline.workers">
    type: long
  </definition>
  <definition term="logstash.node.state.pipeline.representation.hash">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.representation.type">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.representation.version">
    type: keyword
  </definition>
  <definition term="logstash.node.state.pipeline.representation.graph.edges">
    type: object
  </definition>
  <definition term="logstash.node.state.pipeline.representation.graph.vertices">
    type: object
  </definition>
  <definition term="logstash.node.host">
    Host name
    type: alias
    alias to: host.hostname
  </definition>
  <definition term="logstash.node.version">
    Logstash Version
    type: alias
    alias to: service.version
  </definition>
</definitions>


## jvm

JVM Info
<definitions>
  <definition term="logstash.node.jvm.version">
    Version
    type: keyword
  </definition>
  <definition term="logstash.node.jvm.pid">
    Process ID
    type: alias
    alias to: process.pid
  </definition>
  <definition term="logstash.node.stats.timestamp">
    type: date
  </definition>
  <definition term="logstash.node.stats.jvm.uptime_in_millis">
    type: long
  </definition>
  <definition term="logstash.node.stats.jvm.mem.heap_used_in_bytes">
    type: long
  </definition>
  <definition term="logstash.node.stats.jvm.mem.heap_max_in_bytes">
    type: long
  </definition>
</definitions>


## events

Events stats
<definitions>
  <definition term="logstash.node.stats.events.in">
    Incoming events counter.
    type: long
  </definition>
  <definition term="logstash.node.stats.events.out">
    Outgoing events counter.
    type: long
  </definition>
  <definition term="logstash.node.stats.events.filtered">
    Filtered events counter.
    type: long
  </definition>
  <definition term="logstash.node.stats.events.duration_in_millis">
    type: long
  </definition>
  <definition term="logstash.node.stats.logstash.uuid">
    type: keyword
  </definition>
  <definition term="logstash.node.stats.logstash.version">
    type: keyword
  </definition>
  <definition term="logstash.node.stats.os.cpu.load_average.15m">
    type: half_float
  </definition>
  <definition term="logstash.node.stats.os.cpu.load_average.1m">
    type: half_float
  </definition>
  <definition term="logstash.node.stats.os.cpu.load_average.5m">
    type: half_float
  </definition>
  <definition term="logstash.node.stats.os.cgroup.cpuacct.usage_nanos">
    type: long
  </definition>
  <definition term="logstash.node.stats.os.cgroup.cpu.cfs_quota_micros">
    type: long
  </definition>
  <definition term="logstash.node.stats.os.cgroup.cpu.stat.number_of_elapsed_periods">
    type: long
  </definition>
  <definition term="logstash.node.stats.os.cgroup.cpu.stat.time_throttled_nanos">
    type: long
  </definition>
  <definition term="logstash.node.stats.os.cgroup.cpu.stat.number_of_times_throttled">
    type: long
  </definition>
  <definition term="logstash.node.stats.process.cpu.percent">
    type: double
  </definition>
  <definition term="logstash.node.stats.pipelines">
    type: nested
  </definition>
  <definition term="logstash.node.stats.queue.events_count">
    type: long
  </definition>
</definitions>