﻿---
title: Linux fields
description: linux module linux system metrics conntrack summary of nf_conntrack statistics, summed across CPU cores iostat ksm KSM statistics Linux memory data memory...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux fields
linux module

## linux

linux system metrics

## conntrack

<applies-to>
  - Elastic Stack: Beta
</applies-to>

conntrack

## summary

summary of nf_conntrack statistics, summed across CPU cores
<definitions>
  <definition term="linux.conntrack.summary.drop">
    packets dropped due to conntrack failiure
    type: long
  </definition>
  <definition term="linux.conntrack.summary.early_drop">
    conntrack entries dropped to make room for new ones
    type: long
  </definition>
  <definition term="linux.conntrack.summary.entries">
    entries in the conntrack table
    type: long
  </definition>
  <definition term="linux.conntrack.summary.found">
    successfully searched entries
    type: long
  </definition>
  <definition term="linux.conntrack.summary.ignore">
    packets seen already connected to a conntrack entry
    type: long
  </definition>
  <definition term="linux.conntrack.summary.insert_failed">
    Number of entries where list insert insert failed
    type: long
  </definition>
  <definition term="linux.conntrack.summary.invalid">
    packets seen that cannot be tracked
    type: long
  </definition>
  <definition term="linux.conntrack.summary.search_restart">
    table lookups which had to be restarted due to table resizes
    type: long
  </definition>
</definitions>


## iostat

<applies-to>
  - Elastic Stack: Beta
</applies-to>

iostat
<definitions>
  <definition term="linux.iostat.read.request.merges_per_sec">
    The number of read requests merged per second that were queued to the device.
    type: float
  </definition>
  <definition term="linux.iostat.write.request.merges_per_sec">
    The number of write requests merged per second that were queued to the device.
    type: float
  </definition>
  <definition term="linux.iostat.read.request.per_sec">
    The number of read requests that were issued to the device per second
    type: float
  </definition>
  <definition term="linux.iostat.write.request.per_sec">
    The number of write requests that were issued to the device per second
    type: float
  </definition>
  <definition term="linux.iostat.read.per_sec.bytes">
    The number of Bytes read from the device per second.
    type: float
    format: bytes
  </definition>
  <definition term="linux.iostat.read.await">
    The average time spent for read requests issued to the device to be served.
    type: float
  </definition>
  <definition term="linux.iostat.write.per_sec.bytes">
    The number of Bytes write from the device per second.
    type: float
    format: bytes
  </definition>
  <definition term="linux.iostat.write.await">
    The average time spent for write requests issued to the device to be served.
    type: float
  </definition>
  <definition term="linux.iostat.request.avg_size">
    The average size (in bytes) of the requests that were issued to the device.
    type: float
  </definition>
  <definition term="linux.iostat.queue.avg_size">
    The average queue length of the requests that were issued to the device.
    type: float
  </definition>
  <definition term="linux.iostat.await">
    The average time spent for requests issued to the device to be served.
    type: float
  </definition>
  <definition term="linux.iostat.service_time">
    The average service time (in milliseconds) for I/O requests that were issued to the device.
    type: float
  </definition>
  <definition term="linux.iostat.busy">
    Percentage of CPU time during which I/O requests were issued to the device (bandwidth utilization for the device). Device saturation occurs when this value is close to 100%.
    type: float
  </definition>
</definitions>


## ksm

<applies-to>
  - Elastic Stack: Beta
</applies-to>

ksm

## stats

KSM statistics
<definitions>
  <definition term="linux.ksm.stats.pages_shared">
    Shared pages in use.
    type: long
  </definition>
  <definition term="linux.ksm.stats.pages_sharing">
    Sites sharing pages.
    type: long
  </definition>
  <definition term="linux.ksm.stats.pages_unshared">
    Unique pages.
    type: long
  </definition>
  <definition term="linux.ksm.stats.full_scans">
    Number of times mergable pages have been scanned.
    type: long
  </definition>
  <definition term="linux.ksm.stats.stable_node_chains">
    Pages that have reached max_page_sharing.
    type: long
  </definition>
  <definition term="linux.ksm.stats.stable_node_dups">
    Number of duplicated KSM pages.
    type: long
  </definition>
</definitions>


## memory

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Linux memory data

## page_stats

memory page statistics
<definitions>
  <definition term="linux.memory.page_stats.pgscan_kswapd.pages">
    pages scanned by kswapd
    type: long
    format: number
  </definition>
  <definition term="linux.memory.page_stats.pgscan_direct.pages">
    pages scanned directly
    type: long
    format: number
  </definition>
  <definition term="linux.memory.page_stats.pgfree.pages">
    pages freed by the system
    type: long
    format: number
  </definition>
  <definition term="linux.memory.page_stats.pgsteal_kswapd.pages">
    number of pages reclaimed by kswapd
    type: long
    format: number
  </definition>
  <definition term="linux.memory.page_stats.pgsteal_direct.pages">
    number of pages reclaimed directly
    type: long
    format: number
  </definition>
  <definition term="linux.memory.page_stats.direct_efficiency.pct">
    direct reclaim efficiency percentage. A lower percentage indicates the system is struggling to reclaim memory.
    type: scaled_float
    format: percent
  </definition>
  <definition term="linux.memory.page_stats.kswapd_efficiency.pct">
    kswapd reclaim efficiency percentage. A lower percentage indicates the system is struggling to reclaim memory.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## hugepages

This group contains statistics related to huge pages usage on the system.
<definitions>
  <definition term="linux.memory.hugepages.total">
    Number of huge pages in the pool.
    type: long
    format: number
  </definition>
  <definition term="linux.memory.hugepages.used.bytes">
    Memory used in allocated huge pages.
    type: long
    format: bytes
  </definition>
  <definition term="linux.memory.hugepages.used.pct">
    Percentage of huge pages used.
    type: long
    format: percent
  </definition>
  <definition term="linux.memory.hugepages.free">
    Number of available huge pages in the pool.
    type: long
    format: number
  </definition>
  <definition term="linux.memory.hugepages.reserved">
    Number of reserved but not allocated huge pages in the pool.
    type: long
    format: number
  </definition>
  <definition term="linux.memory.hugepages.surplus">
    Number of overcommited huge pages.
    type: long
    format: number
  </definition>
  <definition term="linux.memory.hugepages.default_size">
    Default size for huge pages.
    type: long
    format: bytes
  </definition>
</definitions>


## swap

This group contains statistics related to the swap memory usage on the system.
<definitions>
  <definition term="linux.memory.swap.total">
    Total swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="linux.memory.swap.used.bytes">
    Used swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="linux.memory.swap.free">
    Available swap memory.
    type: long
    format: bytes
  </definition>
  <definition term="linux.memory.swap.used.pct">
    The percentage of used swap memory.
    type: scaled_float
    format: percent
  </definition>
  <definition term="linux.memory.swap.in.pages">
    Pages swapped in.
    type: long
  </definition>
  <definition term="linux.memory.swap.out.pages">
    Pages swapped out.
    type: long
  </definition>
  <definition term="linux.memory.swap.readahead.cached">
    Swap readahead pages hit from swap_ra_hit.
    type: long
  </definition>
  <definition term="linux.memory.swap.readahead.pages">
    Pages swapped based on readahead predictions.
    type: long
  </definition>
</definitions>


## pageinfo

<applies-to>
  - Elastic Stack: Beta
</applies-to>

pageinfo

## buddy_info

Data from /proc/buddyinfo grouping used pages by order

## DMA

DMA page Data
<definitions>
  <definition term="linux.pageinfo.buddy_info.DMA.0">
    free chunks of 2^0*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.1">
    free chunks of 2^1*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.2">
    free chunks of 2^2*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.3">
    free chunks of 2^3*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.4">
    free chunks of 2^4*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.5">
    free chunks of 2^5*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.6">
    free chunks of 2^6*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.7">
    free chunks of 2^7*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.8">
    free chunks of 2^8*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.9">
    free chunks of 2^9*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.buddy_info.DMA.10">
    free chunks of 2^10*PAGE_SIZE
    type: long
  </definition>
  <definition term="linux.pageinfo.nodes.*">
    Raw allocation info from /proc/pagetypeinfo
    type: object
  </definition>
</definitions>


## pressure

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Linux pressure stall information metrics for cpu, memory, and io
<definitions>
  <definition term="linux.pressure.cpu.some.10.pct">
    The average share of time in which at least some tasks were stalled on CPU over a ten second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.cpu.some.60.pct">
    The average share of time in which at least some tasks were stalled on CPU over a sixty second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.cpu.some.300.pct">
    The average share of time in which at least some tasks were stalled on CPU over a three hundred second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.cpu.some.total.time.us">
    The total absolute stall time (in microseconds) in which at least some tasks were stalled on CPU.
    type: long
  </definition>
  <definition term="linux.pressure.memory.some.10.pct">
    The average share of time in which at least some tasks were stalled on Memory over a ten second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.some.60.pct">
    The average share of time in which at least some tasks were stalled on Memory over a sixty second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.some.300.pct">
    The average share of time in which at least some tasks were stalled on Memory over a three hundred second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.some.total.time.us">
    The total absolute stall time (in microseconds) in which at least some tasks were stalled on memory.
    type: long
  </definition>
  <definition term="linux.pressure.memory.full.10.pct">
    The average share of time in which in which all non-idle tasks were stalled on memory simultaneously over a ten second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.full.60.pct">
    The average share of time in which in which all non-idle tasks were stalled on memory simultaneously over a sixty second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.full.300.pct">
    The average share of time in which in which all non-idle tasks were stalled on memory simultaneously over a three hundred second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.memory.full.total.time.us">
    The total absolute stall time (in microseconds) in which in which all non-idle tasks were stalled on memory.
    type: long
  </definition>
  <definition term="linux.pressure.io.some.10.pct">
    The average share of time in which at least some tasks were stalled on io over a ten second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.some.60.pct">
    The average share of time in which at least some tasks were stalled on io over a sixty second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.some.300.pct">
    The average share of time in which at least some tasks were stalled on io over a three hundred second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.some.total.time.us">
    The total absolute stall time (in microseconds) in which at least some tasks were stalled on io.
    type: long
  </definition>
  <definition term="linux.pressure.io.full.10.pct">
    The average share of time in which in which all non-idle tasks were stalled on io simultaneously over a ten second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.full.60.pct">
    The average share of time in which in which all non-idle tasks were stalled on io simultaneously over a sixty second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.full.300.pct">
    The average share of time in which in which all non-idle tasks were stalled on io simultaneously over a three hundred second window.
    type: float
    format: percent
  </definition>
  <definition term="linux.pressure.io.full.total.time.us">
    The total absolute stall time (in microseconds) in which in which all non-idle tasks were stalled on io.
    type: long
  </definition>
</definitions>


## rapl

<applies-to>
  - Elastic Stack: Beta
</applies-to>

Wattage as reported by Intel RAPL
<definitions>
  <definition term="linux.rapl.core">
    The core where the RAPL request originated from. Only one core is queried per hardware CPU.
    type: long
  </definition>
  <definition term="linux.rapl.dram.watts">
    Power usage in watts on the DRAM RAPL domain
    type: float
  </definition>
  <definition term="linux.rapl.dram.joules">
    Raw power usage counter for the DRAM domain
    type: float
  </definition>
  <definition term="linux.rapl.pp0.watts">
    Power usage in watts on the PP0 RAPL domain
    type: float
  </definition>
  <definition term="linux.rapl.pp0.joules">
    Raw power usage counter for the PP0 domain
    type: float
  </definition>
  <definition term="linux.rapl.pp1.watts">
    Power usage in watts on the PP1 RAPL domain
    type: float
  </definition>
  <definition term="linux.rapl.pp1.joules">
    Raw power usage counter for the PP1 domain
    type: float
  </definition>
  <definition term="linux.rapl.package.watts">
    Power usage in watts on the Package RAPL domain
    type: float
  </definition>
  <definition term="linux.rapl.package.joules">
    Raw power usage counter for the package domain
    type: float
  </definition>
</definitions>