﻿---
title: Kubernetes fields
description: Kubernetes metrics Information and statistics of pods managed by kubernetes. Kubernetes API server metrics kubernetes container metrics CPU usage metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes fields
Kubernetes metrics

## kubernetes

Information and statistics of pods managed by kubernetes.

## apiserver

Kubernetes API server metrics
<definitions>
  <definition term="kubernetes.apiserver.major.version">
    API Server major version.
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.minor.version">
    API Server minor version.
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.resource">
    Requested resource
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.subresource">
    Requested subresource
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.scope">
    Request scope (cluster, namespace, resource)
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.verb">
    HTTP verb
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.code">
    HTTP code
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.content_type">
    Request HTTP content type
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.dry_run">
    Wether the request uses dry run
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.kind">
    Kind of request
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.component">
    Component handling the request
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.group">
    API group for the resource
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.version">
    version for the group
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.handler">
    Request handler
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.method">
    HTTP method
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.request.host">
    Request host
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.process.cpu.sec">
    CPU seconds
    type: double
  </definition>
  <definition term="kubernetes.apiserver.process.memory.resident.bytes">
    Bytes in resident memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.apiserver.process.memory.virtual.bytes">
    Bytes in virtual memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.apiserver.process.fds.open.count">
    Number of open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.apiserver.process.started.sec">
    Seconds since the process started
    type: double
  </definition>
  <definition term="kubernetes.apiserver.watch.events.size.bytes.bucket.*">
    Watch event size distribution in bytes
    type: object
  </definition>
  <definition term="kubernetes.apiserver.watch.events.size.bytes.sum">
    Sum of watch events sizes in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.apiserver.watch.events.size.bytes.count">
    Number of watch events
    type: long
  </definition>
  <definition term="kubernetes.apiserver.watch.events.kind">
    Resource kind of the watch event
    type: keyword
  </definition>
  <definition term="kubernetes.apiserver.response.size.bytes.bucket.*">
    Response size distribution in bytes for each group, version, verb, resource, subresource, scope and component.
    type: object
  </definition>
  <definition term="kubernetes.apiserver.response.size.bytes.sum">
    Sum of responses sizes in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.apiserver.response.size.bytes.count">
    Number of responses to requests
    type: long
  </definition>
  <definition term="kubernetes.apiserver.client.request.count">
    Number of requests as client
    type: long
  </definition>
  <definition term="kubernetes.apiserver.request.count">
    Number of requests
    type: long
  </definition>
  <definition term="kubernetes.apiserver.request.duration.us.sum">
    Request duration, sum in microseconds
    type: long
  </definition>
  <definition term="kubernetes.apiserver.request.duration.us.count">
    Request duration, number of operations
    type: long
  </definition>
  <definition term="kubernetes.apiserver.request.duration.us.bucket.*">
    Response latency distribution, histogram buckets
    type: object
  </definition>
  <definition term="kubernetes.apiserver.request.current.count">
    Inflight requests
    type: long
  </definition>
  <definition term="kubernetes.apiserver.request.longrunning.count">
    Number of requests active long running requests
    type: long
  </definition>
  <definition term="kubernetes.apiserver.etcd.object.count">
    Number of kubernetes objects at etcd
    type: long
  </definition>
  <definition term="kubernetes.apiserver.audit.event.count">
    Number of audit events
    type: long
  </definition>
  <definition term="kubernetes.apiserver.audit.rejected.count">
    Number of audit rejected events
    type: long
  </definition>
</definitions>


## container

kubernetes container metrics
<definitions>
  <definition term="kubernetes.container.start_time">
    Start time
    type: date
  </definition>
</definitions>


## cpu

CPU usage metrics
<definitions>
  <definition term="kubernetes.container.cpu.usage.core.ns">
    Container CPU Core usage nanoseconds
    type: double
  </definition>
  <definition term="kubernetes.container.cpu.usage.nanocores">
    CPU used nanocores
    type: double
  </definition>
  <definition term="kubernetes.container.cpu.usage.node.pct">
    CPU usage as a percentage of the total node allocatable CPU
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.container.cpu.usage.limit.pct">
    CPU usage as a percentage of the defined limit for the container (or total node allocatable CPU if unlimited). If the container CPU limits are missing and the `node` and `state_node` metricsets are both disabled on that node, this metric will be missing entirely.
    type: scaled_float
    format: percent
  </definition>
</definitions>


## logs

Logs info
<definitions>
  <definition term="kubernetes.container.logs.available.bytes">
    Logs available capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.logs.capacity.bytes">
    Logs total capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.logs.used.bytes">
    Logs used capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.logs.inodes.count">
    Total available inodes
    type: double
  </definition>
  <definition term="kubernetes.container.logs.inodes.free">
    Total free inodes
    type: double
  </definition>
  <definition term="kubernetes.container.logs.inodes.used">
    Total used inodes
    type: double
  </definition>
  <definition term="kubernetes.container.memory.available.bytes">
    Total available memory
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.memory.usage.bytes">
    Total memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.memory.usage.node.pct">
    Memory usage as a percentage of the total node allocatable memory
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.container.memory.usage.limit.pct">
    Memory usage as a percentage of the defined limit for the container (or total node allocatable memory if unlimited). If the container Memory limits are missing and the `node` and `state_node` metricsets are both disabled on that node, this metric will be missing entirely.
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.container.memory.rss.bytes">
    RSS memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.memory.workingset.bytes">
    Working set memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.memory.workingset.limit.pct">
    Working set memory usage as a percentage of the defined limit for the container (or total node allocatable memory if unlimited)
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.container.memory.pagefaults">
    Number of page faults
    type: double
  </definition>
  <definition term="kubernetes.container.memory.majorpagefaults">
    Number of major page faults
    type: double
  </definition>
  <definition term="kubernetes.container.rootfs.capacity.bytes">
    Root filesystem total capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.rootfs.available.bytes">
    Root filesystem total available in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.rootfs.used.bytes">
    Root filesystem total used in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.container.rootfs.inodes.used">
    Used inodes
    type: double
  </definition>
</definitions>


## controllermanager

Controller manager metrics
<definitions>
  <definition term="kubernetes.controllermanager.verb">
    HTTP verb
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.code">
    HTTP code
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.method">
    HTTP method
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.host">
    HTTP host
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.name">
    Name for the resource
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.zone">
    Infrastructure zone
    type: keyword
  </definition>
  <definition term="kubernetes.controllermanager.process.cpu.sec">
    Total user and system CPU time spent in seconds
    type: double
  </definition>
  <definition term="kubernetes.controllermanager.process.memory.resident.bytes">
    Bytes in resident memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.controllermanager.process.memory.virtual.bytes">
    Bytes in virtual memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.controllermanager.process.fds.open.count">
    Number of open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.process.fds.max.count">
    Limit for open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.process.started.sec">
    Start time of the process since unix epoch in seconds
    type: double
  </definition>
  <definition term="kubernetes.controllermanager.client.request.count">
    Number of HTTP requests to API server, broken down by status code, method and host
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.client.request.duration.us.sum">
    Sum of requests latency in microseconds, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.client.request.duration.us.count">
    Number of request duration operations to API server, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.client.request.duration.us.bucket.*">
    Requests latency distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.controllermanager.client.request.size.bytes.sum">
    Requests size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.controllermanager.client.request.size.bytes.count">
    Number of requests, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.client.request.size.bytes.bucket.*">
    Requests size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.controllermanager.client.response.size.bytes.count">
    Number of responses, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.client.response.size.bytes.sum">
    Responses size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.controllermanager.client.response.size.bytes.bucket.*">
    Responses size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.controllermanager.workqueue.longestrunning.sec">
    How many seconds has the longest running processor been running, broken down by workqueue name
    type: double
  </definition>
  <definition term="kubernetes.controllermanager.workqueue.unfinished.sec">
    How many seconds of work has done that is in progress and hasn't been considered in the longest running processor, broken down by workqueue name
    type: double
  </definition>
  <definition term="kubernetes.controllermanager.workqueue.adds.count">
    Workqueue add count, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.workqueue.depth.count">
    Workqueue current depth, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.workqueue.retries.count">
    Workqueue number of retries, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.node.collector.eviction.count">
    Number of node evictions, broken down by zone
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.node.collector.unhealthy.count">
    Number of unhealthy nodes, broken down by zone
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.node.collector.count">
    Number of nodes, broken down by zone
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.node.collector.health.pct">
    Percentage of healthy nodes, broken down by zone
    type: long
  </definition>
  <definition term="kubernetes.controllermanager.leader.is_master">
    Whether the controller manager instance is leader
    type: boolean
  </definition>
</definitions>


## event

The Kubernetes events metricset collects events that are generated by objects running inside of Kubernetes
<definitions>
  <definition term="kubernetes.event.count">
    Count field records the number of times the particular event has occurred
    type: long
  </definition>
  <definition term="kubernetes.event.timestamp.first_occurrence">
    Timestamp of first occurrence of event
    type: date
  </definition>
  <definition term="kubernetes.event.timestamp.last_occurrence">
    Timestamp of last occurrence of event
    type: date
  </definition>
  <definition term="kubernetes.event.message">
    Message recorded for the given event
    type: text
  </definition>
  <definition term="kubernetes.event.reason">
    Reason recorded for the given event
    type: keyword
  </definition>
  <definition term="kubernetes.event.type">
    Type of the given event
    type: keyword
  </definition>
</definitions>


## source

The component reporting this event
<definitions>
  <definition term="kubernetes.event.source.component">
    Component from which the event is generated
    type: keyword
  </definition>
  <definition term="kubernetes.event.source.host">
    Node name on which the event is generated
    type: keyword
  </definition>
</definitions>


## metadata

Metadata associated with the given event
<definitions>
  <definition term="kubernetes.event.metadata.timestamp.created">
    Timestamp of creation of the given event
    type: date
  </definition>
  <definition term="kubernetes.event.metadata.generate_name">
    Generate name of the event
    type: keyword
  </definition>
  <definition term="kubernetes.event.metadata.name">
    Name of the event
    type: keyword
  </definition>
  <definition term="kubernetes.event.metadata.namespace">
    Namespace in which event was generated
    type: keyword
  </definition>
  <definition term="kubernetes.event.metadata.resource_version">
    Version of the event resource
    type: keyword
  </definition>
  <definition term="kubernetes.event.metadata.uid">
    Unique identifier to the event object
    type: keyword
  </definition>
  <definition term="kubernetes.event.metadata.self_link">
    URL representing the event
    type: keyword
  </definition>
</definitions>


## involved_object

Metadata associated with the given involved object
<definitions>
  <definition term="kubernetes.event.involved_object.api_version">
    API version of the object
    type: keyword
  </definition>
  <definition term="kubernetes.event.involved_object.kind">
    API kind of the object
    type: keyword
  </definition>
  <definition term="kubernetes.event.involved_object.name">
    name of the object
    type: keyword
  </definition>
  <definition term="kubernetes.event.involved_object.resource_version">
    resource version of the object
    type: keyword
  </definition>
  <definition term="kubernetes.event.involved_object.uid">
    UUID version of the object
    type: keyword
  </definition>
</definitions>


## node

kubernetes node metrics
<definitions>
  <definition term="kubernetes.node.start_time">
    Start time
    type: date
  </definition>
</definitions>


## cpu

CPU usage metrics
<definitions>
  <definition term="kubernetes.node.cpu.usage.core.ns">
    Node CPU Core usage nanoseconds
    type: double
  </definition>
  <definition term="kubernetes.node.cpu.usage.nanocores">
    CPU used nanocores
    type: double
  </definition>
  <definition term="kubernetes.node.memory.available.bytes">
    Total available memory
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.memory.usage.bytes">
    Total memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.memory.rss.bytes">
    RSS memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.memory.workingset.bytes">
    Working set memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.memory.pagefaults">
    Number of page faults
    type: double
  </definition>
  <definition term="kubernetes.node.memory.majorpagefaults">
    Number of major page faults
    type: double
  </definition>
  <definition term="kubernetes.node.network.rx.bytes">
    Received bytes on the default interface. If default interface is not defined, will be reported not correct value `0`
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.network.rx.errors">
    Rx errors on the default interface. If default interface is not defined, will be reported not correct value `0`
    type: double
  </definition>
  <definition term="kubernetes.node.network.tx.bytes">
    Transmitted bytes on the default interface. If default interface is not defined, will be reported not correct value `0`
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.network.tx.errors">
    Tx errors on the default interface. If default interface is not defined, will be reported not correct value `0`
    type: double
  </definition>
  <definition term="kubernetes.node.fs.capacity.bytes">
    Filesystem total capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.fs.available.bytes">
    Filesystem total available in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.fs.used.bytes">
    Filesystem total used in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.fs.inodes.used">
    Number of used inodes
    type: double
  </definition>
  <definition term="kubernetes.node.fs.inodes.count">
    Number of inodes
    type: double
  </definition>
  <definition term="kubernetes.node.fs.inodes.free">
    Number of free inodes
    type: double
  </definition>
  <definition term="kubernetes.node.runtime.imagefs.capacity.bytes">
    Image filesystem total capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.runtime.imagefs.available.bytes">
    Image filesystem total available in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.node.runtime.imagefs.used.bytes">
    Image filesystem total used in bytes
    type: double
    format: bytes
  </definition>
</definitions>


## pod

kubernetes pod metrics
<definitions>
  <definition term="kubernetes.pod.start_time">
    Start time
    type: date
  </definition>
  <definition term="kubernetes.pod.network.rx.bytes">
    Received bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.network.rx.errors">
    Rx errors
    type: double
  </definition>
  <definition term="kubernetes.pod.network.tx.bytes">
    Transmitted bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.network.tx.errors">
    Tx errors
    type: double
  </definition>
</definitions>


## cpu

CPU usage metrics
<definitions>
  <definition term="kubernetes.pod.cpu.usage.nanocores">
    CPU used nanocores
    type: double
  </definition>
  <definition term="kubernetes.pod.cpu.usage.node.pct">
    CPU usage as a percentage of the total node CPU
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.pod.cpu.usage.limit.pct">
    CPU usage as a percentage of the defined cpu limits sum of the pod containers. If any container is missing a limit the metric is not emitted.
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.pod.memory.usage.bytes">
    Total memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.memory.usage.node.pct">
    Memory usage as a percentage of the total node allocatable memory
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.pod.memory.usage.limit.pct">
    Memory usage as a percentage of the defined memory limits sum of the pod containers. If any container is missing a limit the metric is not emitted.
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.pod.memory.available.bytes">
    Total memory available
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.memory.working_set.bytes">
    Total working set memory
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.memory.working_set.limit.pct">
    Working set memory usage as a percentage of the defined limits sum of the pod containers. If any container is missing a limit the metric is not emitted.
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.pod.memory.rss.bytes">
    Total resident set size memory
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.pod.memory.page_faults">
    Total page faults
    type: double
  </definition>
  <definition term="kubernetes.pod.memory.major_page_faults">
    Total major page faults
    type: double
  </definition>
</definitions>


## proxy

Kubernetes proxy server metrics
<definitions>
  <definition term="kubernetes.proxy.code">
    HTTP code
    type: keyword
  </definition>
  <definition term="kubernetes.proxy.method">
    HTTP method
    type: keyword
  </definition>
  <definition term="kubernetes.proxy.host">
    HTTP host
    type: keyword
  </definition>
  <definition term="kubernetes.proxy.verb">
    HTTP verb
    type: keyword
  </definition>
  <definition term="kubernetes.proxy.process.cpu.sec">
    Total user and system CPU time spent in seconds
    type: double
  </definition>
  <definition term="kubernetes.proxy.process.memory.resident.bytes">
    Bytes in resident memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.proxy.process.memory.virtual.bytes">
    Bytes in virtual memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.proxy.process.fds.open.count">
    Number of open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.proxy.process.fds.max.count">
    Limit for open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.proxy.process.started.sec">
    Start time of the process since unix epoch in seconds
    type: double
  </definition>
  <definition term="kubernetes.proxy.client.request.count">
    Number of HTTP requests to API server, broken down by status code, method and host
    type: long
  </definition>
  <definition term="kubernetes.proxy.client.request.duration.us.sum">
    Sum of requests latency in microseconds, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.proxy.client.request.duration.us.count">
    Number of request duration operations to API server, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.proxy.client.request.duration.us.bucket.*">
    Requests latency distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.proxy.client.request.size.bytes.sum">
    Requests size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.proxy.client.request.size.bytes.count">
    Number of requests, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.proxy.client.request.size.bytes.bucket.*">
    Requests size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.proxy.client.response.size.bytes.count">
    Number of responses, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.proxy.client.response.size.bytes.sum">
    Responses size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.proxy.client.response.size.bytes.bucket.*">
    Responses size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
</definitions>


## sync

kubeproxy proxy sync metrics
<definitions>
  <definition term="kubernetes.proxy.sync.rules.duration.us.sum">
    SyncProxyRules latency sum in microseconds
    type: long
  </definition>
  <definition term="kubernetes.proxy.sync.rules.duration.us.count">
    Number of SyncProxyRules latency operations
    type: long
  </definition>
  <definition term="kubernetes.proxy.sync.rules.duration.us.bucket.*">
    SyncProxyRules latency distribution in histogram buckets
    type: object
  </definition>
  <definition term="kubernetes.proxy.sync.networkprogramming.duration.us.sum">
    Sum of network programming latency in microseconds
    type: long
  </definition>
  <definition term="kubernetes.proxy.sync.networkprogramming.duration.us.count">
    Number of network programming latency operations
    type: long
  </definition>
  <definition term="kubernetes.proxy.sync.networkprogramming.duration.us.bucket.*">
    Network programming latency distribution in histogram buckets
    type: object
  </definition>
</definitions>


## scheduler

Kubernetes scheduler metrics
<definitions>
  <definition term="kubernetes.scheduler.verb">
    HTTP verb
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.host">
    HTTP host
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.code">
    HTTP code
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.method">
    HTTP method
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.queue">
    Scheduling queue
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.event">
    Scheduling event
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.profile">
    Scheduling profile
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.result">
    Attempt result to schedule pod
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.name">
    Name for the resource
    type: keyword
  </definition>
  <definition term="kubernetes.scheduler.leader.is_master">
    Whether the scheduler instance is leader
    type: boolean
  </definition>
  <definition term="kubernetes.scheduler.process.cpu.sec">
    Total user and system CPU time spent in seconds
    type: double
  </definition>
  <definition term="kubernetes.scheduler.process.memory.resident.bytes">
    Bytes in resident memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.scheduler.process.memory.virtual.bytes">
    Bytes in virtual memory
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.scheduler.process.fds.open.count">
    Number of open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.scheduler.process.fds.max.count">
    Limit for open file descriptors
    type: long
  </definition>
  <definition term="kubernetes.scheduler.process.started.sec">
    Start time of the process since unix epoch in seconds
    type: double
  </definition>
  <definition term="kubernetes.scheduler.client.request.count">
    Number of HTTP requests to API server, broken down by status code, method and host
    type: long
  </definition>
  <definition term="kubernetes.scheduler.client.request.duration.us.sum">
    Sum of requests latency in microseconds, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.scheduler.client.request.duration.us.count">
    Number of request duration operations to API server, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.scheduler.client.request.duration.us.bucket.*">
    Requests latency distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.scheduler.client.request.size.bytes.sum">
    Requests size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.scheduler.client.request.size.bytes.count">
    Number of requests, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.scheduler.client.request.size.bytes.bucket.*">
    Requests size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.scheduler.client.response.size.bytes.count">
    Number of responses, broken down by verb and host
    type: long
  </definition>
  <definition term="kubernetes.scheduler.client.response.size.bytes.sum">
    Responses size sum in bytes, broken down by verb and host
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.scheduler.client.response.size.bytes.bucket.*">
    Responses size distribution in histogram buckets, broken down by verb and host
    type: object
  </definition>
  <definition term="kubernetes.scheduler.workqueue.longestrunning.sec">
    How many seconds has the longest running processor been running, broken down by workqueue name
    type: double
  </definition>
  <definition term="kubernetes.scheduler.workqueue.unfinished.sec">
    How many seconds of work has done that is in progress and hasn't been considered in the longest running processor, broken down by workqueue name
    type: double
  </definition>
  <definition term="kubernetes.scheduler.workqueue.adds.count">
    Workqueue add count, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.scheduler.workqueue.depth.count">
    Workqueue current depth, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.scheduler.workqueue.retries.count">
    Workqueue number of retries, broken down by workqueue name
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.pending.pods.count">
    Number of current pending pods, broken down by the queue type
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.preemption.victims.bucket.*">
    Number of preemption victims distribution in histogram buckets
    type: object
  </definition>
  <definition term="kubernetes.scheduler.scheduling.preemption.victims.sum">
    Preemption victims sum
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.preemption.victims.count">
    Number of preemption victims
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.preemption.attempts.count">
    Total preemption attempts in the cluster so far
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.attempts.duration.us.bucket.*">
    Scheduling attempt latency distribution in histogram buckets, broken down by profile and result
    type: object
  </definition>
  <definition term="kubernetes.scheduler.scheduling.attempts.duration.us.sum">
    Sum of scheduling attempt latency in microseconds, broken down by profile and result
    type: long
  </definition>
  <definition term="kubernetes.scheduler.scheduling.attempts.duration.us.count">
    Number of scheduling attempts, broken down by profile and result
    type: long
  </definition>
</definitions>


## container

kubernetes container metrics
<definitions>
  <definition term="kubernetes.container.id">
    Container id
    type: keyword
  </definition>
  <definition term="kubernetes.container.status.phase">
    Container phase (running, waiting, terminated)
    type: keyword
  </definition>
  <definition term="kubernetes.container.status.ready">
    Container ready status
    type: boolean
  </definition>
  <definition term="kubernetes.container.status.restarts">
    Container restarts count
    type: integer
  </definition>
  <definition term="kubernetes.container.status.reason">
    The reason the container is currently in waiting (ContainerCreating, CrashLoopBackoff, ErrImagePull, ImagePullBackoff) or terminated (Completed, ContainerCannotRun, Error, OOMKilled) state.
    type: keyword
  </definition>
  <definition term="kubernetes.container.status.last_terminated_reason">
    The last reason the container was in terminated state (Completed, ContainerCannotRun, Error or OOMKilled).
    type: keyword
  </definition>
  <definition term="kubernetes.container.status.last_terminated_timestamp">
    Last terminated time (epoch) of the container
    type: double
  </definition>
  <definition term="kubernetes.container.status.last_terminated_exitcode">
    The exit code for the last container in terminated state.
    type: integer
  </definition>
  <definition term="kubernetes.container.cpu.limit.cores">
    Container CPU cores limit
    type: float
  </definition>
  <definition term="kubernetes.container.cpu.request.cores">
    Container CPU requested cores
    type: float
  </definition>
  <definition term="kubernetes.container.memory.limit.bytes">
    Container memory limit in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.container.memory.request.bytes">
    Container requested memory in bytes
    type: long
    format: bytes
  </definition>
</definitions>


## cronjob

kubernetes cronjob metrics
<definitions>
  <definition term="kubernetes.cronjob.name">
    Cronjob name
    type: keyword
  </definition>
  <definition term="kubernetes.cronjob.schedule">
    Cronjob schedule
    type: keyword
  </definition>
  <definition term="kubernetes.cronjob.concurrency">
    Concurrency policy
    type: keyword
  </definition>
  <definition term="kubernetes.cronjob.active.count">
    Number of active pods for the cronjob
    type: long
  </definition>
  <definition term="kubernetes.cronjob.is_suspended">
    Whether the cronjob is suspended
    type: boolean
  </definition>
  <definition term="kubernetes.cronjob.created.sec">
    Epoch seconds since the cronjob was created
    type: double
  </definition>
  <definition term="kubernetes.cronjob.last_schedule.sec">
    Epoch seconds for last cronjob run
    type: double
  </definition>
  <definition term="kubernetes.cronjob.next_schedule.sec">
    Epoch seconds for next cronjob run
    type: double
  </definition>
  <definition term="kubernetes.cronjob.deadline.sec">
    Deadline seconds after schedule for considering failed
    type: long
  </definition>
</definitions>


## daemonset

Kubernetes DaemonSet metrics
<definitions>
  <definition term="kubernetes.daemonset.name">
    type: keyword
  </definition>
</definitions>


## replicas

Kubernetes DaemonSet replica metrics
<definitions>
  <definition term="kubernetes.daemonset.replicas.available">
    The number of available replicas per DaemonSet
    type: long
  </definition>
  <definition term="kubernetes.daemonset.replicas.desired">
    The desired number of replicas per DaemonSet
    type: long
  </definition>
  <definition term="kubernetes.daemonset.replicas.ready">
    The number of ready replicas per DaemonSet
    type: long
  </definition>
  <definition term="kubernetes.daemonset.replicas.unavailable">
    The number of unavailable replicas per DaemonSet
    type: long
  </definition>
</definitions>


## deployment

kubernetes deployment metrics
<definitions>
  <definition term="kubernetes.deployment.paused">
    Kubernetes deployment paused status
    type: boolean
  </definition>
  <definition term="kubernetes.deployment.status.available">
    Deployment Available Condition status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.deployment.status.progressing">
    Deployment Progresing Condition status (true, false or unknown)
    type: keyword
  </definition>
</definitions>


## replicas

Kubernetes deployment replicas info
<definitions>
  <definition term="kubernetes.deployment.replicas.desired">
    Deployment number of desired replicas (spec)
    type: integer
  </definition>
  <definition term="kubernetes.deployment.replicas.available">
    Deployment available replicas
    type: integer
  </definition>
  <definition term="kubernetes.deployment.replicas.unavailable">
    Deployment unavailable replicas
    type: integer
  </definition>
  <definition term="kubernetes.deployment.replicas.updated">
    Deployment updated replicas
    type: integer
  </definition>
</definitions>


## horizontalpodautoscaler

<applies-to>
  - Elastic Stack: Beta
</applies-to>

kubernetes horizontalpodautoscaler metrics
<definitions>
  <definition term="kubernetes.horizontalpodautoscaler.name">
    The Kubernetes Horizontal Pod Autoscaler name
    type: keyword
  </definition>
</definitions>


## replicas

Kubernetes HPA replicas metrics
<definitions>
  <definition term="kubernetes.horizontalpodautoscaler.replicas.max">
    Kubernetes HPA maximum replicas from spec
    type: integer
  </definition>
  <definition term="kubernetes.horizontalpodautoscaler.replicas.min">
    Kubernetes HPA minimum replicas from spec
    type: integer
  </definition>
  <definition term="kubernetes.horizontalpodautoscaler.replicas.current">
    Kubernetes HPA current replicas from status
    type: integer
  </definition>
  <definition term="kubernetes.horizontalpodautoscaler.replicas.desired">
    Kubernetes HPA desired replicas from status
    type: integer
  </definition>
</definitions>


## status

Kubernetes HPA status metrics
<definitions>
  <definition term="kubernetes.horizontalpodautoscaler.status.condition">
    Kubernetes HPA scaling condition
    type: keyword
  </definition>
</definitions>


## job

Kubernetes job metrics
<definitions>
  <definition term="kubernetes.job.name">
    The name of the job resource
    type: keyword
  </definition>
</definitions>


## pods

Pod metrics for the job
<definitions>
  <definition term="kubernetes.job.pods.active">
    Number of active pods
    type: long
  </definition>
  <definition term="kubernetes.job.pods.failed">
    Number of failed pods
    type: long
  </definition>
  <definition term="kubernetes.job.pods.succeeded">
    Number of successful pods
    type: long
  </definition>
</definitions>


## time

Kubernetes job timestamps
<definitions>
  <definition term="kubernetes.job.time.created">
    The time at which the job was created
    type: date
  </definition>
  <definition term="kubernetes.job.time.completed">
    The time at which the job completed
    type: date
  </definition>
</definitions>


## completions

Kubernetes job completion settings
<definitions>
  <definition term="kubernetes.job.completions.desired">
    The configured completion count for the job (Spec)
    type: long
  </definition>
</definitions>


## parallelism

Kubernetes job parallelism settings
<definitions>
  <definition term="kubernetes.job.parallelism.desired">
    The configured parallelism of the job (Spec)
    type: long
  </definition>
</definitions>


## owner

Kubernetes job owner information
<definitions>
  <definition term="kubernetes.job.owner.name">
    The name of the resource that owns this job
    type: keyword
  </definition>
  <definition term="kubernetes.job.owner.kind">
    The kind of resource that owns this job (eg. "CronJob")
    type: keyword
  </definition>
  <definition term="kubernetes.job.owner.is_controller">
    Owner is controller ("true", "false", or "<none>")
    type: keyword
  </definition>
</definitions>


## status

Kubernetes job status information
<definitions>
  <definition term="kubernetes.job.status.complete">
    Whether the job completed ("true", "false", or "unknown")
    type: keyword
  </definition>
  <definition term="kubernetes.job.status.failed">
    Whether the job failed ("true", "false", or "unknown")
    type: keyword
  </definition>
</definitions>


## state_namespace

Kubernetes namespace metrics.
<definitions>
  <definition term="kubernetes.state_namespace.created.sec">
    Unix creation timestamp.
    type: double
  </definition>
  <definition term="kubernetes.state_namespace.status.active">
    Whether the namespace is active (true or false).
    type: boolean
  </definition>
  <definition term="kubernetes.state_namespace.status.terminating">
    Whether the namespace is terminating (true or false).
    type: boolean
  </definition>
</definitions>


## node

kubernetes node metrics
<definitions>
  <definition term="kubernetes.node.status.ready">
    Node ready status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.status.unschedulable">
    Node unschedulable status
    type: boolean
  </definition>
  <definition term="kubernetes.node.status.memory_pressure">
    Node MemoryPressure status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.status.disk_pressure">
    Node DiskPressure status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.status.out_of_disk">
    Node OutOfDisk status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.status.pid_pressure">
    Node PIDPressure status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.status.network_unavailable">
    Node NetworkUnavailable status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.node.cpu.allocatable.cores">
    The allocatable CPU cores of a node that are available for pods scheduling
    type: float
  </definition>
  <definition term="kubernetes.node.cpu.capacity.cores">
    Node CPU capacity cores
    type: long
  </definition>
  <definition term="kubernetes.node.memory.allocatable.bytes">
    The allocatable memory of a node in bytes that is available for pods scheduling
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.node.memory.capacity.bytes">
    Node memory capacity in bytes
    type: long
    format: bytes
  </definition>
  <definition term="kubernetes.node.pod.allocatable.total">
    Node allocatable pods
    type: long
  </definition>
  <definition term="kubernetes.node.pod.capacity.total">
    Node pod capacity
    type: long
  </definition>
  <definition term="kubernetes.node.kubelet.version">
    Kubelet version.
    type: keyword
  </definition>
</definitions>


## persistentvolume

kubernetes persistent volume metrics from kube-state-metrics
<definitions>
  <definition term="kubernetes.persistentvolume.name">
    Volume name.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolume.capacity.bytes">
    Volume capacity
    type: long
  </definition>
  <definition term="kubernetes.persistentvolume.phase">
    Volume phase according to kubernetes
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolume.storage_class">
    Storage class for the volume
    type: keyword
  </definition>
</definitions>


## persistentvolumeclaim

kubernetes persistent volume claim metrics from kube-state-metrics
<definitions>
  <definition term="kubernetes.persistentvolumeclaim.name">
    PVC name.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.volume_name">
    Binded volume name.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.request_storage.bytes">
    Requested capacity.
    type: long
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.phase">
    PVC phase.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.access_mode">
    Access mode.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.storage_class">
    Storage class for the PVC.
    type: keyword
  </definition>
  <definition term="kubernetes.persistentvolumeclaim.created">
    PersistentVolumeClaim creation date
    type: date
  </definition>
</definitions>


## pod

kubernetes pod metrics
<definitions>
  <definition term="kubernetes.pod.host_ip">
    Kubernetes pod host IP
    type: ip
  </definition>
</definitions>


## status

Kubernetes pod status metrics
<definitions>
  <definition term="kubernetes.pod.status.phase">
    Kubernetes pod phase (Running, Pending...)
    type: keyword
  </definition>
  <definition term="kubernetes.pod.status.ready">
    Kubernetes pod ready status (true, false or unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.pod.status.scheduled">
    Kubernetes pod scheduled status (true, false, unknown)
    type: keyword
  </definition>
  <definition term="kubernetes.pod.status.reason">
    The reason the pod is in its current state (Evicted, NodeAffinity, NodeLost, Shutdown or UnexpectedAdmissionError)
    type: keyword
  </definition>
  <definition term="kubernetes.pod.status.ready_time">
    Readiness achieved time in unix timestamp for a pod
    type: double
  </definition>
</definitions>


## replicaset

kubernetes replica set metrics

## replicas

Kubernetes replica set paused status
<definitions>
  <definition term="kubernetes.replicaset.replicas.available">
    The number of replicas per ReplicaSet
    type: long
  </definition>
  <definition term="kubernetes.replicaset.replicas.desired">
    The number of replicas per ReplicaSet
    type: long
  </definition>
  <definition term="kubernetes.replicaset.replicas.ready">
    The number of ready replicas per ReplicaSet
    type: long
  </definition>
  <definition term="kubernetes.replicaset.replicas.observed">
    The generation observed by the ReplicaSet controller
    type: long
  </definition>
  <definition term="kubernetes.replicaset.replicas.labeled">
    The number of fully labeled replicas per ReplicaSet
    type: long
  </definition>
</definitions>


## resourcequota

kubernetes resourcequota metrics
<definitions>
  <definition term="kubernetes.resourcequota.created.sec">
    Epoch seconds since the ResourceQuota was created
    type: double
  </definition>
  <definition term="kubernetes.resourcequota.quota">
    Quota informed (hard or used) for the resource
    type: double
  </definition>
  <definition term="kubernetes.resourcequota.name">
    ResourceQuota name
    type: keyword
  </definition>
  <definition term="kubernetes.resourcequota.type">
    Quota information type, `hard` or `used`
    type: keyword
  </definition>
  <definition term="kubernetes.resourcequota.resource">
    Resource name the quota applies to
    type: keyword
  </definition>
</definitions>


## service

kubernetes service metrics
<definitions>
  <definition term="kubernetes.service.name">
    Service name.
    type: keyword
  </definition>
  <definition term="kubernetes.service.cluster_ip">
    Internal IP for the service.
    type: keyword
  </definition>
  <definition term="kubernetes.service.external_name">
    Service external DNS name
    type: keyword
  </definition>
  <definition term="kubernetes.service.external_ip">
    Service external IP
    type: keyword
  </definition>
  <definition term="kubernetes.service.load_balancer_ip">
    Load Balancer service IP
    type: keyword
  </definition>
  <definition term="kubernetes.service.type">
    Service type
    type: keyword
  </definition>
  <definition term="kubernetes.service.ingress_ip">
    Ingress IP
    type: keyword
  </definition>
  <definition term="kubernetes.service.ingress_hostname">
    Ingress Hostname
    type: keyword
  </definition>
  <definition term="kubernetes.service.created">
    Service creation date
    type: date
  </definition>
</definitions>


## statefulset

kubernetes stateful set metrics
<definitions>
  <definition term="kubernetes.statefulset.created">
    The creation timestamp (epoch) for StatefulSet
    type: long
  </definition>
</definitions>


## replicas

Kubernetes stateful set replicas status
<definitions>
  <definition term="kubernetes.statefulset.replicas.observed">
    The number of observed replicas per StatefulSet
    type: long
  </definition>
  <definition term="kubernetes.statefulset.replicas.desired">
    The number of desired replicas per StatefulSet
    type: long
  </definition>
  <definition term="kubernetes.statefulset.replicas.ready">
    The number of ready replicas per StatefulSet
    type: long
  </definition>
</definitions>


## generation

Kubernetes stateful set generation information
<definitions>
  <definition term="kubernetes.statefulset.generation.observed">
    The observed generation per StatefulSet
    type: long
  </definition>
  <definition term="kubernetes.statefulset.generation.desired">
    The desired generation per StatefulSet
    type: long
  </definition>
</definitions>


## storageclass

kubernetes storage class metrics
<definitions>
  <definition term="kubernetes.storageclass.name">
    Storage class name.
    type: keyword
  </definition>
  <definition term="kubernetes.storageclass.provisioner">
    Volume provisioner for the storage class.
    type: keyword
  </definition>
  <definition term="kubernetes.storageclass.reclaim_policy">
    Reclaim policy for dynamically created volumes
    type: keyword
  </definition>
  <definition term="kubernetes.storageclass.volume_binding_mode">
    Mode for default provisioning and binding
    type: keyword
  </definition>
  <definition term="kubernetes.storageclass.created">
    Storage class creation date
    type: date
  </definition>
</definitions>


## system

kubernetes system containers metrics
<definitions>
  <definition term="kubernetes.system.container">
    Container name
    type: keyword
  </definition>
  <definition term="kubernetes.system.start_time">
    Start time
    type: date
  </definition>
</definitions>


## cpu

CPU usage metrics
<definitions>
  <definition term="kubernetes.system.cpu.usage.core.ns">
    CPU Core usage nanoseconds
    type: double
  </definition>
  <definition term="kubernetes.system.cpu.usage.nanocores">
    CPU used nanocores
    type: double
  </definition>
  <definition term="kubernetes.system.memory.usage.bytes">
    Total memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.system.memory.rss.bytes">
    RSS memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.system.memory.workingset.bytes">
    Working set memory usage
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.system.memory.pagefaults">
    Number of page faults
    type: double
  </definition>
  <definition term="kubernetes.system.memory.majorpagefaults">
    Number of major page faults
    type: double
  </definition>
</definitions>


## volume

kubernetes volume metrics
<definitions>
  <definition term="kubernetes.volume.name">
    Volume name
    type: keyword
  </definition>
  <definition term="kubernetes.volume.fs.capacity.bytes">
    Filesystem total capacity in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.volume.fs.available.bytes">
    Filesystem total available in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.volume.fs.used.bytes">
    Filesystem total used in bytes
    type: double
    format: bytes
  </definition>
  <definition term="kubernetes.volume.fs.used.pct">
    Percentage of used storage
    type: scaled_float
    format: percent
  </definition>
  <definition term="kubernetes.volume.fs.inodes.used">
    Used inodes
    type: double
  </definition>
  <definition term="kubernetes.volume.fs.inodes.free">
    Free inodes
    type: double
  </definition>
  <definition term="kubernetes.volume.fs.inodes.count">
    Total inodes
    type: double
  </definition>
  <definition term="kubernetes.volume.fs.inodes.pct">
    Percentage of used inodes
    type: scaled_float
    format: percent
  </definition>
</definitions>